/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.util.StringUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentPropertyKey;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelGroupPropertyKey;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyEntryInstance;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.tooling.model.MainModel;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CamelPropertyKeyInstance
implements ILineRangeDefineable {
    static final String CAMEL_KEY_PREFIX = "camel.";
    static final String CAMEL_COMPONENT_KEY_PREFIX = "camel.component.";
    private String camelPropertyKey;
    private CamelGroupPropertyKey propertyGroup;
    private CamelComponentPropertyKey camelComponentPropertyKey;
    private CamelPropertyEntryInstance camelPropertyEntryInstance;

    public CamelPropertyKeyInstance(String camelPropertyFileKey, CamelPropertyEntryInstance camelPropertyEntryInstance) {
        this.camelPropertyKey = camelPropertyFileKey;
        this.camelPropertyEntryInstance = camelPropertyEntryInstance;
        if (camelPropertyFileKey.startsWith(CAMEL_COMPONENT_KEY_PREFIX)) {
            this.camelComponentPropertyKey = new CamelComponentPropertyKey(camelPropertyFileKey.substring(CAMEL_COMPONENT_KEY_PREFIX.length()), this);
        }
        if (this.camelPropertyKey.startsWith(CAMEL_KEY_PREFIX)) {
            this.propertyGroup = new CamelGroupPropertyKey(camelPropertyFileKey.substring(CAMEL_KEY_PREFIX.length()), this);
        }
    }

    public int getEndposition() {
        return this.camelPropertyEntryInstance.getStartPositionInLine() + this.camelPropertyKey.length();
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        int indexOfSecondDot;
        int indexOfFirstDot = this.camelPropertyKey.indexOf(46);
        int n = indexOfSecondDot = indexOfFirstDot != -1 ? this.camelPropertyKey.indexOf(46, indexOfFirstDot + 1) : -1;
        if (this.isBeforeFirstDot(position, indexOfFirstDot)) {
            CompletionItem completionItem = new CompletionItem("camel");
            String insertText = indexOfFirstDot != -1 ? "camel" : CAMEL_KEY_PREFIX;
            completionItem.setInsertText(insertText);
            completionItem.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(this.getLine(), this.getStartPositionInLine()), new Position(this.getLine(), indexOfFirstDot != -1 ? this.getStartPositionInLine() + indexOfFirstDot : this.getEndPositionInLine())), insertText)));
            return CompletableFuture.completedFuture(Collections.singletonList(completionItem));
        }
        if (this.isBetweenFirstAndSecondDotOfCamelPropertyKey(position, indexOfSecondDot)) {
            return this.getTopLevelCamelCompletion(camelCatalog, indexOfSecondDot, position.getCharacter());
        }
        if (this.camelComponentPropertyKey != null && this.camelComponentPropertyKey.isInRange(position.getCharacter())) {
            return this.camelComponentPropertyKey.getCompletions(position, camelCatalog);
        }
        if (this.propertyGroup != null && this.propertyGroup.isInRange(position.getCharacter())) {
            return this.propertyGroup.getCompletions(position, camelCatalog);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private boolean isBetweenFirstAndSecondDotOfCamelPropertyKey(Position position, int indexOfSecondDot) {
        return this.getStartPositionInLine() + CAMEL_KEY_PREFIX.length() <= position.getCharacter() && this.camelPropertyKey.startsWith(CAMEL_KEY_PREFIX) && position.getCharacter() <= this.getStartPositionInLine() + Math.max(CAMEL_KEY_PREFIX.length(), indexOfSecondDot);
    }

    private boolean isBeforeFirstDot(Position position, int indexOfFirstDot) {
        return this.getStartPositionInLine() <= position.getCharacter() && position.getCharacter() <= this.getStartPositionInLine() + Math.max(0, indexOfFirstDot);
    }

    protected CompletableFuture<List<CompletionItem>> getTopLevelCamelCompletion(CompletableFuture<CamelCatalog> camelCatalog, int indexOfSecondDot, int completionPositionRequest) {
        String filterString = this.camelPropertyKey.substring(CAMEL_KEY_PREFIX.length(), completionPositionRequest - this.getStartPositionInLine());
        return camelCatalog.thenApply(catalog -> {
            MainModel mainModel = (MainModel)new Gson().fromJson(catalog.mainJsonSchema(), MainModel.class);
            ArrayList<CompletionItem> allCompletionItems = new ArrayList<CompletionItem>();
            allCompletionItems.addAll(this.createGroupCompletionFromMainModel(mainModel, indexOfSecondDot));
            allCompletionItems.add(this.createCompletionItemForCamelComponent(indexOfSecondDot));
            return allCompletionItems.stream().filter(FilterPredicateUtils.matchesCompletionFilter(filterString)).collect(Collectors.toList());
        });
    }

    private CompletionItem createCompletionItemForCamelComponent(int indexOfSecondDot) {
        CompletionItem completionItem = new CompletionItem("component");
        String insertText = indexOfSecondDot != -1 ? "component" : "component.";
        completionItem.setInsertText(insertText);
        Position start = new Position(this.getLine(), this.getStartPositionInLine() + CAMEL_KEY_PREFIX.length());
        Position end = new Position(this.getLine(), indexOfSecondDot != -1 ? this.getStartPositionInLine() + indexOfSecondDot : this.getEndPositionInLine());
        Range range = new Range(start, end);
        TextEdit textEdit = new TextEdit(range, insertText);
        completionItem.setTextEdit(Either.forLeft((Object)textEdit));
        return completionItem;
    }

    private List<CompletionItem> createGroupCompletionFromMainModel(MainModel mainModel, int indexOfSecondDot) {
        return mainModel.getGroups().stream().map(group -> {
            String realGroupName = group.getName().replaceFirst(CAMEL_KEY_PREFIX, "");
            CompletionItem completionItem = new CompletionItem(realGroupName);
            completionItem.setDocumentation(group.getDescription());
            Object insertText = indexOfSecondDot != -1 ? realGroupName : realGroupName + ".";
            completionItem.setInsertText((String)insertText);
            Position start = new Position(this.getLine(), this.getStartPositionInLine() + CAMEL_KEY_PREFIX.length());
            Position end = new Position(this.getLine(), indexOfSecondDot != -1 ? this.getStartPositionInLine() + indexOfSecondDot : this.getEndPositionInLine());
            Range range = new Range(start, end);
            completionItem.setTextEdit(Either.forLeft((Object)new TextEdit(range, (String)insertText)));
            return completionItem;
        }).collect(Collectors.toList());
    }

    public String getCamelPropertyKey() {
        return this.camelPropertyKey;
    }

    public CamelComponentPropertyKey getCamelComponentPropertyKey() {
        return this.camelComponentPropertyKey;
    }

    public CamelPropertyEntryInstance getCamelPropertyEntryInstance() {
        return this.camelPropertyEntryInstance;
    }

    @Override
    public int getLine() {
        return this.camelPropertyEntryInstance.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.camelPropertyEntryInstance.getStartPositionInLine();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.camelPropertyKey.length();
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.camelComponentPropertyKey != null && this.camelComponentPropertyKey.isInRange(position.getCharacter())) {
            return this.camelComponentPropertyKey.getHover(position, camelCatalog);
        }
        if (this.propertyGroup != null && this.propertyGroup.isInRange(position.getCharacter())) {
            return this.propertyGroup.getHover(position, camelCatalog);
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean shouldUseDashedCase() {
        return this.camelPropertyEntryInstance.shouldUseDashedCase();
    }

    public Collection<Diagnostic> validate(Set<CamelPropertyEntryInstance> allCamelPropertyEntriesOfTheFile) {
        Optional<String> duplicateByDashCamelNotationDifference;
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        if (this.camelPropertyKey != null && this.camelPropertyKey.startsWith(CAMEL_KEY_PREFIX) && (duplicateByDashCamelNotationDifference = allCamelPropertyEntriesOfTheFile.stream().map(CamelPropertyEntryInstance::getCamelPropertyKeyInstance).filter(Objects::nonNull).map(CamelPropertyKeyInstance::getCamelPropertyKey).filter(Objects::nonNull).filter(iterCamelPropertyKey -> !iterCamelPropertyKey.equals(this.camelPropertyKey) && StringUtils.dashToCamelCase(iterCamelPropertyKey).equals(StringUtils.dashToCamelCase(this.camelPropertyKey))).findAny()).isPresent()) {
            diagnostics.add(new Diagnostic(new Range(new Position(this.getLine(), this.getStartPositionInLine()), new Position(this.getLine(), this.getEndPositionInLine())), "Duplicated properties using different Dash/camel case notation: " + duplicateByDashCamelNotationDifference.get(), DiagnosticSeverity.Error, "Apache Camel validation"));
        }
        return diagnostics;
    }
}

