/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamKeyURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamValueURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.v1.Kamelet;
import org.apache.camel.v1.KameletSpec;
import org.apache.camel.v1.kameletspec.definition.Properties;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;

public class OptionParamURIInstance
extends CamelUriElementInstance {
    public static final String INVALID_URI_OPTION = "The parameter %s is not a known parameter of the component. Check if it is written correctly and is supported by the used Camel version (see pom.xml).";
    private OptionParamKeyURIInstance key;
    private OptionParamValueURIInstance value;
    private CamelURIInstance camelURIInstance;

    public OptionParamURIInstance(CamelURIInstance camelURIInstance, String optionParam, int startPosition, int endPosition) {
        super(startPosition, endPosition);
        this.camelURIInstance = camelURIInstance;
        String[] splittedParams = optionParam.split("=");
        String keyName = splittedParams[0];
        this.key = new OptionParamKeyURIInstance(this, splittedParams[0], startPosition, startPosition + keyName.length());
        if (splittedParams.length > 1) {
            this.value = new OptionParamValueURIInstance(this, splittedParams[1], startPosition + keyName.length() + 1, endPosition);
        } else if (optionParam.endsWith("=")) {
            this.value = new OptionParamValueURIInstance(this, null, startPosition + keyName.length() + 1, endPosition);
        }
    }

    public OptionParamKeyURIInstance getKey() {
        return this.key;
    }

    public OptionParamValueURIInstance getValue() {
        return this.value;
    }

    public CamelUriElementInstance getSpecificElement(int position) {
        if (this.key.isInRange(position)) {
            return this.key;
        }
        return this.value;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public String getComponentName() {
        return this.camelURIInstance.getComponentName();
    }

    public boolean isProducer() {
        return this.camelURIInstance.isProducer();
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        String keyName = this.getKey().getKeyName();
        EndpointOptionModel model = componentModel.getEndpointOption(keyName);
        if (model != null) {
            return model.getDescription();
        }
        if ("kamelet".equalsIgnoreCase(componentModel.getScheme())) {
            Properties prop = this.getKameletPropertyByKeyName(kameletCatalogManager, keyName);
            if (prop != null) {
                return prop.getDescription();
            }
            return String.format(INVALID_URI_OPTION, keyName);
        }
        Optional<EndpointOptionModel> apiProperty = this.findAvailableApiProperties(componentModel).stream().filter(endpointOptionModel -> endpointOptionModel.getName().equals(keyName)).findAny();
        return apiProperty.isPresent() ? apiProperty.get().getDescription() : String.format(INVALID_URI_OPTION, keyName);
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this.camelURIInstance;
    }

    private Properties getKameletPropertyByKeyName(KameletsCatalogManager kameletCatalogManager, String keyName) {
        List kamelets;
        Optional<String> kameletTemplateId = this.getCamelUriInstance().getComponentAndPathUriElementInstance().getPathParams().stream().filter(pathParam -> pathParam.getPathParamIndex() == 0).map(PathParamURIInstance::getValue).findAny();
        if (kameletTemplateId.isPresent() && !(kamelets = kameletCatalogManager.getCatalog().getKameletsByName(kameletTemplateId.get())).isEmpty()) {
            Kamelet kamelet = (Kamelet)kamelets.get(0);
            return (Properties)((KameletSpec)kamelet.getSpec()).getDefinition().getProperties().get(keyName);
        }
        return null;
    }
}

