/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CamelOptionNamesCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamURIInstance;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;

public class OptionParamKeyURIInstance
extends CamelUriElementInstance {
    private String keyName;
    private OptionParamURIInstance optionParamURIInstance;

    public OptionParamKeyURIInstance(OptionParamURIInstance optionParamURIInstance, String keyName, int startPosition, int endPosition) {
        super(startPosition, endPosition);
        this.optionParamURIInstance = optionParamURIInstance;
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public OptionParamURIInstance getOptionParamURIInstance() {
        return this.optionParamURIInstance;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        if (this.getStartPositionInUri() <= positionInCamelUri && positionInCamelUri <= this.getEndPositionInUri()) {
            return camelCatalog.thenApply((Function)new CamelOptionNamesCompletionsFuture(this, this.getComponentName(), this.optionParamURIInstance.isProducer(), this.getFilter(positionInCamelUri), positionInCamelUri, this.getAlreadyDefinedUriOptions(), kameletsCatalogManager, settingsManager.isMardownSupport()));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public String getComponentName() {
        return this.optionParamURIInstance.getComponentName();
    }

    private String getFilter(int positionInUri) {
        int len = positionInUri - this.getStartPositionInUri() - 1;
        if (this.keyName != null && this.keyName.trim().length() > 0 && this.getStartPositionInUri() != positionInUri) {
            return this.keyName.length() > len ? this.keyName.substring(0, Math.max(1, len)) : this.keyName;
        }
        return null;
    }

    private Set<OptionParamURIInstance> getAlreadyDefinedUriOptions() {
        return this.optionParamURIInstance.getCamelUriInstance().getOptionParams();
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        return this.optionParamURIInstance.getDescription(componentModel, kameletCatalogManager);
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this.optionParamURIInstance.getCamelUriInstance();
    }
}

