/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.hover;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.catalog.util.StringUtils;
import com.github.cameltooling.lsp.internal.hover.CamelURIHoverFuture;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperFactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelURIHoverProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelURIHoverProcessor.class);
    private TextDocumentItem textDocumentItem;
    private CompletableFuture<CamelCatalog> camelCatalog;
    private KameletsCatalogManager kameletCatalogManager;

    public CamelURIHoverProcessor(TextDocumentItem textDocumentItem, CompletableFuture<CamelCatalog> camelCatalog, KameletsCatalogManager kameletCatalogManager) {
        this.textDocumentItem = textDocumentItem;
        this.camelCatalog = camelCatalog;
        this.kameletCatalogManager = kameletCatalogManager;
    }

    public CompletableFuture<Hover> getHover(Position position) {
        try {
            String camelComponentUri;
            String componentName;
            ParserFileHelper parserFileHelper = new ParserFileHelperFactory().getCorrespondingParserFileHelper(this.textDocumentItem, position.getLine());
            if (parserFileHelper != null && (componentName = StringUtils.asComponentName(camelComponentUri = parserFileHelper.getCamelComponentUri(this.textDocumentItem, position))) != null) {
                CamelURIInstance camelURIInstance = parserFileHelper.createCamelURIInstance(this.textDocumentItem, position, camelComponentUri);
                int positionInCamelUri = parserFileHelper.getPositionInCamelURI(this.textDocumentItem, position);
                CamelUriElementInstance elem = camelURIInstance.getSpecificElement(positionInCamelUri);
                return this.camelCatalog.thenApply((Function)new CamelURIHoverFuture(elem, this.kameletCatalogManager));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error searching hover", (Throwable)e);
        }
        return CompletableFuture.completedFuture(null);
    }
}

