/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.documentsymbol;

import com.github.cameltooling.lsp.internal.documentsymbol.DocumentSymbolJavaProcessor;
import com.github.cameltooling.lsp.internal.documentsymbol.DocumentSymbolXMLProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DocumentSymbolProcessor {
    private TextDocumentItem textDocumentItem;

    public DocumentSymbolProcessor(TextDocumentItem textDocumentItem) {
        this.textDocumentItem = textDocumentItem;
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> getDocumentSymbols() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList symbolInformations = new ArrayList();
            if (this.textDocumentItem.getUri().endsWith(".xml")) {
                return new DocumentSymbolXMLProcessor(this.textDocumentItem).getSymbolInformations();
            }
            if (this.textDocumentItem.getUri().endsWith(".java")) {
                return new DocumentSymbolJavaProcessor(this.textDocumentItem).getSymbolInformations();
            }
            return symbolInformations;
        });
    }
}

