/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.documentsymbol;

import com.github.cameltooling.lsp.internal.catalog.util.CamelNodeDetailsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractDocumentSymbolProcessor {
    protected TextDocumentItem textDocumentItem;

    protected AbstractDocumentSymbolProcessor(TextDocumentItem textDocumentItem) {
        this.textDocumentItem = textDocumentItem;
    }

    protected List<Either<SymbolInformation, DocumentSymbol>> createSymbolInformations(List<CamelNodeDetails> camelNodes, List<CamelEndpointDetails> endpoints) {
        ArrayList<Either<SymbolInformation, DocumentSymbol>> symbolInformations = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        if (camelNodes != null) {
            for (CamelNodeDetails camelNodeDetails : camelNodes) {
                Range range = new CamelNodeDetailsUtils().computeRange(camelNodeDetails, this.textDocumentItem);
                Optional<String> componentName = endpoints.stream().filter(ced -> Integer.valueOf(ced.getLineNumber()) - 1 == range.getStart().getLine()).map(CamelEndpointDetails::getEndpointUri).map(this::shortEndpoint).findFirst();
                symbolInformations.add(this.createSymbolInformation(camelNodeDetails, range, componentName));
                symbolInformations.addAll(this.createSymbolInformations(camelNodeDetails.getOutputs(), endpoints));
            }
        }
        return symbolInformations;
    }

    private Either<SymbolInformation, DocumentSymbol> createSymbolInformation(CamelNodeDetails camelNodeDetails, Range range, Optional<String> componentPath) {
        String nodeDetailsName = camelNodeDetails.getName();
        return Either.forRight((Object)new DocumentSymbol((String)(componentPath.isPresent() ? nodeDetailsName + " " + componentPath.get() : nodeDetailsName), SymbolKind.Field, range, range));
    }

    private String shortEndpoint(String uri) {
        int pos = uri.indexOf(63);
        return pos != -1 ? uri.substring(0, pos) : uri;
    }
}

