/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.diagnostic.DiagnosticService;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModeline;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import com.github.cameltooling.lsp.internal.parser.CamelKModelineParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelKModelineDiagnosticService
extends DiagnosticService {
    public CamelKModelineDiagnosticService() {
        super(null);
    }

    public Collection<Diagnostic> compute(String camelText, TextDocumentItem documentItem) {
        BufferedReader bufReader = new BufferedReader(new StringReader(camelText));
        String line = null;
        int lineNumber = 0;
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        CamelKModelineParser camelKModelineParser = new CamelKModelineParser();
        try {
            while ((line = bufReader.readLine()) != null) {
                if (camelKModelineParser.retrieveModelineCamelKStart(line) != null) {
                    diagnostics.addAll(this.computeDiagnosticForLine(documentItem, line, lineNumber));
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            this.logExceptionValidatingDocument(documentItem.getUri(), e);
        }
        return diagnostics;
    }

    private Collection<Diagnostic> computeDiagnosticForLine(TextDocumentItem documentItem, String line, int lineNumber) {
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        CamelKModeline camelKModeline = new CamelKModeline(line, documentItem, lineNumber);
        List traitOptions = camelKModeline.getOptions().stream().map(CamelKModelineOption::getOptionValue).filter(CamelKModelineTraitOption.class::isInstance).map(CamelKModelineTraitOption.class::cast).collect(Collectors.toList());
        for (CamelKModelineTraitOption traitOption : traitOptions) {
            for (CamelKModelineTraitOption traitOption2 : traitOptions) {
                if (traitOption.equals(traitOption2)) continue;
                String definitionName = traitOption.getTraitDefinition().getValueAsString();
                String propertyName = traitOption.getTraitProperty().getValueAsString();
                if (definitionName == null || propertyName == null || !definitionName.equals(traitOption2.getTraitDefinition().getValueAsString()) || !propertyName.equals(traitOption2.getTraitProperty().getValueAsString())) continue;
                Range range = new Range(new Position(traitOption2.getLine(), traitOption2.getStartPositionInLine()), new Position(traitOption2.getLine(), traitOption2.getEndPositionInLine()));
                diagnostics.add(new Diagnostic(range, "More than one trait defines the same property: " + definitionName + "." + propertyName));
            }
        }
        return diagnostics;
    }
}

