/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion.traits;

import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinitionProperty;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import org.eclipse.lsp4j.CompletionItem;

public class TraitProperty {
    private String name;
    private String description;
    private String type;
    private Object defaultValue;

    public CompletionItem createCompletionItem(CamelKModelineTraitDefinitionProperty camelKModelineTraitDefinitionProperty) {
        CompletionItem completionItem = new CompletionItem(this.name);
        completionItem.setDocumentation(this.description);
        CamelKModelineTraitOption traitOption = camelKModelineTraitDefinitionProperty.getTraitOption();
        if (this.hasAValueSpecified(traitOption)) {
            completionItem.setInsertText(this.name);
        } else {
            String prefix = this.name + "=";
            if (this.defaultValue != null) {
                if ("int".equals(this.type) && this.defaultValue instanceof Double) {
                    completionItem.setInsertText(prefix + ((Double)this.defaultValue).intValue());
                } else {
                    completionItem.setInsertText(prefix + String.valueOf(this.defaultValue));
                }
            } else {
                completionItem.setInsertText(prefix);
            }
        }
        CompletionResolverUtils.applyTextEditToCompletionItem(camelKModelineTraitDefinitionProperty, completionItem);
        return completionItem;
    }

    private boolean hasAValueSpecified(CamelKModelineTraitOption traitOption) {
        return traitOption.getValueAsString().contains("=");
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }
}

