/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion.traits;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinition;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinitionProperty;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;

public class CamelKTraitManager {
    private static Map<String, JSONSchemaProps> traits;
    private static ObjectMapper mapper;

    private CamelKTraitManager() {
    }

    public static Map<String, JSONSchemaProps> getTraits() {
        if (traits == null) {
            InputStream inputStreamCRD = CamelKTraitManager.class.getResourceAsStream("/camel.apache.org_integrations-2.0.1.yaml");
            try {
                CustomResourceDefinition crd = (CustomResourceDefinition)mapper.readValue(inputStreamCRD, CustomResourceDefinition.class);
                JSONSchemaProps traitsSchema = CamelKTraitManager.retrieveTraitsDefinitionFromCamelKCRD(crd);
                traits = traitsSchema.getProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
                traits = Collections.emptyMap();
            }
        }
        return traits;
    }

    private static JSONSchemaProps retrieveTraitsDefinitionFromCamelKCRD(CustomResourceDefinition crd) {
        return (JSONSchemaProps)((JSONSchemaProps)((CustomResourceDefinitionVersion)crd.getSpec().getVersions().get(0)).getSchema().getOpenAPIV3Schema().getProperties().get("spec")).getProperties().get("traits");
    }

    public static List<CompletionItem> getTraitDefinitionNameCompletionItems(String filter, CamelKModelineTraitDefinition camelKModelineTraitDefinition) {
        return CamelKTraitManager.getTraits().entrySet().stream().map(entryTrait -> {
            CompletionItem completionItem = new CompletionItem((String)entryTrait.getKey());
            completionItem.setDocumentation(((JSONSchemaProps)entryTrait.getValue()).getDescription());
            if (CamelKTraitManager.hasAPropertySpecified(camelKModelineTraitDefinition.getTraitOption())) {
                completionItem.setInsertText((String)entryTrait.getKey());
            } else {
                completionItem.setInsertText((String)entryTrait.getKey() + ".");
            }
            CompletionResolverUtils.applyTextEditToCompletionItem(camelKModelineTraitDefinition, completionItem);
            return completionItem;
        }).filter(FilterPredicateUtils.matchesCompletionFilter(filter)).collect(Collectors.toList());
    }

    private static boolean hasAPropertySpecified(CamelKModelineTraitOption camelKModelineTraitOption) {
        return camelKModelineTraitOption.getTraitProperty() != null;
    }

    public static List<CompletionItem> getTraitPropertyNameCompletionItems(String filter, CamelKModelineTraitDefinitionProperty traitDefinitionProperty) {
        JSONSchemaProps traitDefinition = CamelKTraitManager.getTrait(traitDefinitionProperty.getTraitOption().getTraitDefinition().getValueAsString());
        if (traitDefinition != null) {
            return traitDefinition.getProperties().entrySet().stream().map(traitProperty -> {
                CompletionItem completionItem = new CompletionItem((String)traitProperty.getKey());
                completionItem.setDocumentation(((JSONSchemaProps)traitProperty.getValue()).getDescription());
                CamelKModelineTraitOption traitOption = traitDefinitionProperty.getTraitOption();
                if (CamelKTraitManager.hasAValueSpecified(traitOption)) {
                    completionItem.setInsertText((String)traitProperty.getKey());
                } else {
                    completionItem.setInsertText((String)traitProperty.getKey() + "=");
                }
                CompletionResolverUtils.applyTextEditToCompletionItem(traitDefinitionProperty, completionItem);
                return completionItem;
            }).filter(FilterPredicateUtils.matchesCompletionFilter(filter)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean hasAValueSpecified(CamelKModelineTraitOption traitOption) {
        return traitOption.getValueAsString().contains("=");
    }

    private static JSONSchemaProps getTrait(String traitDefinitionName) {
        return CamelKTraitManager.getTraits().get(traitDefinitionName);
    }

    public static String getDescription(String traitDefinitionName) {
        JSONSchemaProps traitDefinition = CamelKTraitManager.getTrait(traitDefinitionName);
        if (traitDefinition != null) {
            return traitDefinition.getDescription();
        }
        return null;
    }

    public static String getPropertyDescription(String traitDefinitionName, String traitPropertyName) {
        JSONSchemaProps traitProperty;
        JSONSchemaProps traitDefinition = CamelKTraitManager.getTrait(traitDefinitionName);
        if (traitDefinition != null && (traitProperty = CamelKTraitManager.getTraitProperty(traitDefinition, traitPropertyName)) != null) {
            return traitProperty.getDescription();
        }
        return null;
    }

    private static JSONSchemaProps getTraitProperty(JSONSchemaProps traitDefinition, String traitPropertyName) {
        return (JSONSchemaProps)traitDefinition.getProperties().get(traitPropertyName);
    }

    static {
        mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }
}

