/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion.modeline;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.CompletionItem;

public enum CamelKModelineFileType {
    XML(List.of(".camelk.xml"), "<!-- camel-k:", CamelKModelineFileType::xmlCommentPattern, "<!-- camel-k: -->", "Read more: https://camel.apache.org/camel-k/1.9.x/cli/modeline.html"),
    JAVA(List.of(".java"), "// camel-k:", CamelKModelineFileType::javaCommentPattern, "// camel-k: ", "Read more: https://camel.apache.org/camel-k/1.9.x/cli/modeline.html"),
    YAML(List.of(".camelk.yaml", ".camelk.yml"), "# camel-k:", CamelKModelineFileType::yamlCommentPattern, "# camel-k: ", "Read more: https://camel.apache.org/camel-k/1.9.x/cli/modeline.html");

    private final List<String> correspondingExtensions;
    private final String modeline;
    private final Supplier<Pattern> commentRegexSupplier;
    private final CompletionItem completion;
    private static final String DOCUMENTATION = "Read more: https://camel.apache.org/camel-k/1.9.x/cli/modeline.html";

    private CamelKModelineFileType(List<String> correspondingExtensions, String modeline, Supplier<Pattern> commentRegexSupplier, String completionLabel, String completionDocumentation) {
        this.correspondingExtensions = correspondingExtensions;
        this.modeline = modeline;
        this.commentRegexSupplier = commentRegexSupplier;
        this.completion = CamelKModelineFileType.getCompletionItem(completionLabel, completionDocumentation);
    }

    public List<String> getCorrespondingExtensions() {
        return this.correspondingExtensions;
    }

    public String getModeline() {
        return this.modeline;
    }

    public Supplier<Pattern> getCommentRegexSupplier() {
        return this.commentRegexSupplier;
    }

    public CompletionItem getCompletion() {
        return this.completion;
    }

    public static CompletionItem getCompletionItem(String label, String documentation) {
        CompletionItem completion = new CompletionItem(label);
        completion.setDocumentation(documentation);
        return completion;
    }

    public static Optional<CamelKModelineFileType> getFileTypeCorrespondingToUri(String uri) {
        return List.of(CamelKModelineFileType.values()).stream().filter(type -> type.getCorrespondingExtensions().stream().anyMatch(uri::endsWith)).findFirst();
    }

    private static Pattern xmlCommentPattern() {
        return Pattern.compile("<!--.*-->");
    }

    private static Pattern yamlCommentPattern() {
        return Pattern.compile("#.*\\n");
    }

    private static Pattern javaCommentPattern() {
        Pattern lineComment = Pattern.compile("\\/\\/.*\\n");
        Pattern blockComment = Pattern.compile("\\/\\*(?s).*\\*\\/");
        return Pattern.compile(String.format("(%s|%s)", lineComment.pattern(), blockComment.pattern()));
    }
}

