/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.kamelets.catalog.KameletsCatalog;
import org.apache.camel.kamelets.catalog.model.KameletTypeEnum;
import org.apache.camel.v1.Kamelet;
import org.apache.camel.v1.KameletSpec;
import org.eclipse.lsp4j.CompletionItem;

public class KameletTemplateIdCompletionProvider {
    private KameletsCatalogManager kameletsCatalogManager;

    public KameletTemplateIdCompletionProvider(KameletsCatalogManager kameletsCatalogManager) {
        this.kameletsCatalogManager = kameletsCatalogManager;
    }

    public CompletableFuture<List<CompletionItem>> get(PathParamURIInstance pathParamURIInstance) {
        List<Kamelet> kamelets = this.retrievePotentialKamelets(pathParamURIInstance);
        List completionItems = kamelets.stream().map(kamelet -> {
            CompletionItem completionItem = new CompletionItem(kamelet.getMetadata().getName());
            CompletionResolverUtils.applyTextEditToCompletionItem(pathParamURIInstance, completionItem);
            completionItem.setDocumentation(((KameletSpec)kamelet.getSpec()).getDefinition().getDescription());
            return completionItem;
        }).collect(Collectors.toList());
        return CompletableFuture.completedFuture(completionItems);
    }

    private List<Kamelet> retrievePotentialKamelets(PathParamURIInstance pathParamURIInstance) {
        KameletsCatalog kameletsCatalog = this.kameletsCatalogManager.getCatalog();
        if (kameletsCatalog != null) {
            if (pathParamURIInstance.getCamelUriInstance().isProducer()) {
                return kameletsCatalog.getKameletsByType(KameletTypeEnum.SINK.type());
            }
            return kameletsCatalog.getKameletsByType(KameletTypeEnum.SOURCE.type());
        }
        return Collections.emptyList();
    }
}

