/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.codeactions;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.codeactions.AbstractQuickfix;
import com.github.cameltooling.lsp.internal.completion.CamelEndpointCompletionProcessor;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownPropertyQuickfix
extends AbstractQuickfix {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnknownPropertyQuickfix.class);

    public UnknownPropertyQuickfix(CamelTextDocumentService camelTextDocumentService) {
        super(camelTextDocumentService);
    }

    @Override
    protected String getDiagnosticId() {
        return "camel.diagnostic.unknown.properties";
    }

    @Override
    protected List<String> retrievePossibleValues(TextDocumentItem textDocumentItem, CompletableFuture<CamelCatalog> camelCatalog, Position position, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        try {
            return (List)((CompletableFuture)new CamelEndpointCompletionProcessor(textDocumentItem, camelCatalog, kameletsCatalogManager).getCompletions(position, settingsManager).thenApply(completionItems -> completionItems.stream().map(CompletionItem::getInsertText).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interruption while computing possible properties for quickfix", (Throwable)e);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (ExecutionException e) {
            LOGGER.error("Exception while computing possible properties for quickfix", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

