/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.codeactions;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.codeactions.ConvertCamelKPropertyFileModelineRefactorAction;
import com.github.cameltooling.lsp.internal.codeactions.InvalidEnumQuickfix;
import com.github.cameltooling.lsp.internal.codeactions.UnknownPropertyQuickfix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionProcessor {
    private CamelTextDocumentService camelTextDocumentService;

    public CodeActionProcessor(CamelTextDocumentService camelTextDocumentService) {
        this.camelTextDocumentService = camelTextDocumentService;
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> getCodeActions(CodeActionParams params) {
        CodeActionContext context = params.getContext();
        if (context != null) {
            ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
            List codeActionsType = context.getOnly();
            if (codeActionsType == null) {
                codeActions.addAll(this.computeQuickfixes(params));
                codeActions.addAll(this.computeConvertDeprecatedPropertyFileModeline(params));
            } else {
                if (codeActionsType.contains("quickfix")) {
                    codeActions.addAll(this.computeQuickfixes(params));
                }
                if (codeActionsType.contains("refactor")) {
                    codeActions.addAll(this.computeConvertDeprecatedPropertyFileModeline(params));
                }
            }
            return CompletableFuture.supplyAsync(() -> codeActions);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private Collection<Either<Command, CodeAction>> computeConvertDeprecatedPropertyFileModeline(CodeActionParams params) {
        return new ConvertCamelKPropertyFileModelineRefactorAction(this.camelTextDocumentService).getCodeActions(params);
    }

    private List<Either<Command, CodeAction>> computeQuickfixes(CodeActionParams params) {
        ArrayList<Either<Command, CodeAction>> allQuickfixes = new ArrayList<Either<Command, CodeAction>>();
        allQuickfixes.addAll(new UnknownPropertyQuickfix(this.camelTextDocumentService).apply(params));
        allQuickfixes.addAll(new InvalidEnumQuickfix(this.camelTextDocumentService).apply(params));
        return allQuickfixes;
    }
}

