/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.catalog.diagnostic;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.catalog.ConfigurationPropertiesValidationResult;
import org.apache.camel.catalog.EndpointValidationResult;

public class EnumErrorMsg {
    public String getErrorMessage(EndpointValidationResult result, Map.Entry<String, String> entry) {
        Map invalidEnumChoices = result.getInvalidEnumChoices();
        Map defaultValues = result.getDefaultValues();
        return this.getErrorMessage(entry, invalidEnumChoices, defaultValues);
    }

    public String getErrorMessage(ConfigurationPropertiesValidationResult result, Map.Entry<String, String> entry) {
        Map invalidEnumChoices = result.getInvalidEnumChoices();
        Map defaultValues = result.getDefaultValues();
        return this.getErrorMessage(entry, invalidEnumChoices, defaultValues);
    }

    private String getErrorMessage(Map.Entry<String, String> entry, Map<String, String[]> invalidEnumChoices, Map<String, String> defaultValues) {
        String name = entry.getKey();
        String[] choices = invalidEnumChoices.get(name);
        String defaultValue = defaultValues != null ? defaultValues.get(entry.getKey()) : null;
        String str = Arrays.asList(choices).toString();
        String msg = "Invalid enum value: " + entry.getValue() + ". Possible values: " + str;
        if (choices != null && choices.length > 0) {
            str = Arrays.asList(choices).toString();
            msg = msg + ". Did you mean: " + str;
        }
        if (defaultValue != null) {
            msg = msg + ". Default value: " + defaultValue;
        }
        return msg;
    }
}

