/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.graphics.Bitmap;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class StandardGifDecoder
implements GifDecoder {
    private static final String TAG = StandardGifDecoder.class.getSimpleName();
    private static final int MAX_STACK_SIZE = 4096;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int BYTES_PER_INTEGER = 4;
    private static final int MASK_INT_LOWEST_BYTE = 255;
    @ColorInt
    private static final int COLOR_TRANSPARENT_BLACK = 0;
    @ColorInt
    private int[] act;
    @ColorInt
    private final int[] pct = new int[256];
    private final GifDecoder.BitmapProvider bitmapProvider;
    private ByteBuffer rawData;
    private byte[] block;
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    @ColorInt
    private int[] mainScratch;
    private int framePointer;
    private GifHeader header;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;
    private int sampleSize;
    private int downsampledHeight;
    private int downsampledWidth;
    @Nullable
    private Boolean isFirstFrameTransparent;
    @NonNull
    private Bitmap.Config bitmapConfig = Bitmap.Config.ARGB_8888;

    public StandardGifDecoder(@NonNull GifDecoder.BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData) {
        this(provider, gifHeader, rawData, 1);
    }

    public StandardGifDecoder(@NonNull GifDecoder.BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData, int sampleSize) {
        this(provider);
        this.setData(gifHeader, rawData, sampleSize);
    }

    public StandardGifDecoder(@NonNull GifDecoder.BitmapProvider provider) {
        this.bitmapProvider = provider;
        this.header = new GifHeader();
    }

    @Override
    public int getWidth() {
        return this.header.width;
    }

    @Override
    public int getHeight() {
        return this.header.height;
    }

    @Override
    @NonNull
    public ByteBuffer getData() {
        return this.rawData;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    @Override
    public int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.header.frameCount) {
            delay = this.header.frames.get((int)n).delay;
        }
        return delay;
    }

    @Override
    public int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return 0;
        }
        return this.getDelay(this.framePointer);
    }

    @Override
    public int getFrameCount() {
        return this.header.frameCount;
    }

    @Override
    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    @Override
    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    @Override
    @Deprecated
    public int getLoopCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        return this.header.loopCount;
    }

    @Override
    public int getNetscapeLoopCount() {
        return this.header.loopCount;
    }

    @Override
    public int getTotalIterationCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        if (this.header.loopCount == 0) {
            return 0;
        }
        return this.header.loopCount + 1;
    }

    @Override
    public int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    @Override
    @Nullable
    public synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, frameCount=" + this.header.frameCount + ", framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        if (this.block == null) {
            this.block = this.bitmapProvider.obtainByteArray(255);
        }
        GifFrame currentFrame = this.header.frames.get(this.framePointer);
        GifFrame previousFrame = null;
        int previousIndex = this.framePointer - 1;
        if (previousIndex >= 0) {
            previousFrame = this.header.frames.get(previousIndex);
        }
        int[] nArray = this.act = currentFrame.lct != null ? currentFrame.lct : this.header.gct;
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("No valid color table found for frame #" + this.framePointer));
            }
            this.status = 1;
            return null;
        }
        if (currentFrame.transparency) {
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[currentFrame.transIndex] = 0;
        }
        return this.setPixels(currentFrame, previousFrame);
    }

    @Override
    public int read(@Nullable InputStream is, int contentLength) {
        if (is != null) {
            try {
                int nRead;
                int capacity = contentLength > 0 ? contentLength + 4096 : 16384;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(capacity);
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                this.read(buffer.toByteArray());
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)e);
        }
        return this.status;
    }

    @Override
    public void clear() {
        this.header = null;
        if (this.mainPixels != null) {
            this.bitmapProvider.release(this.mainPixels);
        }
        if (this.mainScratch != null) {
            this.bitmapProvider.release(this.mainScratch);
        }
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = null;
        if (this.block != null) {
            this.bitmapProvider.release(this.block);
        }
    }

    @Override
    public synchronized void setData(@NonNull GifHeader header, @NonNull byte[] data) {
        this.setData(header, ByteBuffer.wrap(data));
    }

    @Override
    public synchronized void setData(@NonNull GifHeader header, @NonNull ByteBuffer buffer) {
        this.setData(header, buffer, 1);
    }

    @Override
    public synchronized void setData(@NonNull GifHeader header, @NonNull ByteBuffer buffer, int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.status = 0;
        this.header = header;
        this.framePointer = -1;
        this.rawData = buffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame frame : header.frames) {
            if (frame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.sampleSize = sampleSize;
        this.downsampledWidth = header.width / sampleSize;
        this.downsampledHeight = header.height / sampleSize;
        this.mainPixels = this.bitmapProvider.obtainByteArray(header.width * header.height);
        this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
    }

    @NonNull
    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    @Override
    public synchronized int read(@Nullable byte[] data) {
        this.header = this.getHeaderParser().setData(data).parseHeader();
        if (data != null) {
            this.setData(this.header, data);
        }
        return this.status;
    }

    @Override
    public void setDefaultBitmapConfig(@NonNull Bitmap.Config config) {
        if (config != Bitmap.Config.ARGB_8888 && config != Bitmap.Config.RGB_565) {
            throw new IllegalArgumentException("Unsupported format: " + config + ", must be one of " + Bitmap.Config.ARGB_8888 + " or " + Bitmap.Config.RGB_565);
        }
        this.bitmapConfig = config;
    }

    private Bitmap setPixels(GifFrame currentFrame, GifFrame previousFrame) {
        int[] dest = this.mainScratch;
        if (previousFrame == null) {
            if (this.previousImage != null) {
                this.bitmapProvider.release(this.previousImage);
            }
            this.previousImage = null;
            Arrays.fill(dest, 0);
        }
        if (previousFrame != null && previousFrame.dispose == 3 && this.previousImage == null) {
            Arrays.fill(dest, 0);
        }
        if (previousFrame != null && previousFrame.dispose > 0) {
            if (previousFrame.dispose == 2) {
                int c = 0;
                if (!currentFrame.transparency) {
                    c = this.header.bgColor;
                    if (currentFrame.lct != null && this.header.bgIndex == currentFrame.transIndex) {
                        c = 0;
                    }
                } else if (this.framePointer == 0) {
                    this.isFirstFrameTransparent = true;
                }
                int downsampledIH = previousFrame.ih / this.sampleSize;
                int downsampledIY = previousFrame.iy / this.sampleSize;
                int downsampledIW = previousFrame.iw / this.sampleSize;
                int downsampledIX = previousFrame.ix / this.sampleSize;
                int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
                int bottomLeft = topLeft + downsampledIH * this.downsampledWidth;
                for (int left = topLeft; left < bottomLeft; left += this.downsampledWidth) {
                    int right = left + downsampledIW;
                    for (int pointer = left; pointer < right; ++pointer) {
                        dest[pointer] = c;
                    }
                }
            } else if (previousFrame.dispose == 3 && this.previousImage != null) {
                this.previousImage.getPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
            }
        }
        this.decodeBitmapData(currentFrame);
        if (currentFrame.interlace || this.sampleSize != 1) {
            this.copyCopyIntoScratchRobust(currentFrame);
        } else {
            this.copyIntoScratchFast(currentFrame);
        }
        if (this.savePrevious && (currentFrame.dispose == 0 || currentFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        }
        Bitmap result = this.getNextBitmap();
        result.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        return result;
    }

    private void copyIntoScratchFast(GifFrame currentFrame) {
        int[] dest = this.mainScratch;
        int downsampledIH = currentFrame.ih;
        int downsampledIY = currentFrame.iy;
        int downsampledIW = currentFrame.iw;
        int downsampledIX = currentFrame.ix;
        boolean isFirstFrame = this.framePointer == 0;
        int width = this.downsampledWidth;
        byte[] mainPixels = this.mainPixels;
        int[] act = this.act;
        int transparentColorIndex = -1;
        for (int i = 0; i < downsampledIH; ++i) {
            int line = i + downsampledIY;
            int k = line * width;
            int dx = k + downsampledIX;
            int dlim = dx + downsampledIW;
            if (k + width < dlim) {
                dlim = k + width;
            }
            int sx = i * currentFrame.iw;
            while (dx < dlim) {
                int byteCurrentColorIndex = mainPixels[sx];
                int currentColorIndex = byteCurrentColorIndex & 0xFF;
                if (currentColorIndex != transparentColorIndex) {
                    int color = act[currentColorIndex];
                    if (color != 0) {
                        dest[dx] = color;
                    } else {
                        transparentColorIndex = byteCurrentColorIndex;
                    }
                }
                ++sx;
                ++dx;
            }
        }
        this.isFirstFrameTransparent = this.isFirstFrameTransparent == null && isFirstFrame && transparentColorIndex != -1;
    }

    private void copyCopyIntoScratchRobust(GifFrame currentFrame) {
        int[] dest = this.mainScratch;
        int downsampledIH = currentFrame.ih / this.sampleSize;
        int downsampledIY = currentFrame.iy / this.sampleSize;
        int downsampledIW = currentFrame.iw / this.sampleSize;
        int downsampledIX = currentFrame.ix / this.sampleSize;
        int pass = 1;
        int inc = 8;
        int iline = 0;
        boolean isFirstFrame = this.framePointer == 0;
        int sampleSize = this.sampleSize;
        int downsampledWidth = this.downsampledWidth;
        int downsampledHeight = this.downsampledHeight;
        byte[] mainPixels = this.mainPixels;
        int[] act = this.act;
        Boolean isFirstFrameTransparent = this.isFirstFrameTransparent;
        for (int i = 0; i < downsampledIH; ++i) {
            int averageColor;
            boolean isNotDownsampling;
            int line = i;
            if (currentFrame.interlace) {
                if (iline >= downsampledIH) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                            break;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            boolean bl = isNotDownsampling = sampleSize == 1;
            if ((line += downsampledIY) >= downsampledHeight) continue;
            int k = line * downsampledWidth;
            int dx = k + downsampledIX;
            int dlim = dx + downsampledIW;
            if (k + downsampledWidth < dlim) {
                dlim = k + downsampledWidth;
            }
            int sx = i * sampleSize * currentFrame.iw;
            if (isNotDownsampling) {
                while (dx < dlim) {
                    int currentColorIndex = mainPixels[sx] & 0xFF;
                    averageColor = act[currentColorIndex];
                    if (averageColor != 0) {
                        dest[dx] = averageColor;
                    } else if (isFirstFrame && isFirstFrameTransparent == null) {
                        isFirstFrameTransparent = true;
                    }
                    sx += sampleSize;
                    ++dx;
                }
                continue;
            }
            int maxPositionInSource = sx + (dlim - dx) * sampleSize;
            while (dx < dlim) {
                averageColor = this.averageColorsNear(sx, maxPositionInSource, currentFrame.iw);
                if (averageColor != 0) {
                    dest[dx] = averageColor;
                } else if (isFirstFrame && isFirstFrameTransparent == null) {
                    isFirstFrameTransparent = true;
                }
                sx += sampleSize;
                ++dx;
            }
        }
        if (this.isFirstFrameTransparent == null) {
            this.isFirstFrameTransparent = isFirstFrameTransparent == null ? false : isFirstFrameTransparent;
        }
    }

    @ColorInt
    private int averageColorsNear(int positionInMainPixels, int maxPositionInMainPixels, int currentFrameIw) {
        int currentColor;
        int currentColorIndex;
        int i;
        int alphaSum = 0;
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        int totalAdded = 0;
        for (i = positionInMainPixels; i < positionInMainPixels + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        for (i = positionInMainPixels + currentFrameIw; i < positionInMainPixels + currentFrameIw + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        if (totalAdded == 0) {
            return 0;
        }
        return alphaSum / totalAdded << 24 | redSum / totalAdded << 16 | greenSum / totalAdded << 8 | blueSum / totalAdded;
    }

    private void decodeBitmapData(GifFrame frame) {
        int code;
        int npix;
        if (frame != null) {
            this.rawData.position(frame.bufferFrameStart);
        }
        int n = npix = frame == null ? this.header.width * this.header.height : frame.iw * frame.ih;
        if (this.mainPixels == null || this.mainPixels.length < npix) {
            this.mainPixels = this.bitmapProvider.obtainByteArray(npix);
        }
        byte[] mainPixels = this.mainPixels;
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        short[] prefix = this.prefix;
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        byte[] suffix = this.suffix;
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        byte[] pixelStack = this.pixelStack;
        int dataSize = this.readByte();
        int clear = 1 << dataSize;
        int endOfInformation = clear + 1;
        int available = clear + 2;
        int oldCode = -1;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (code = 0; code < clear; ++code) {
            prefix[code] = 0;
            suffix[code] = (byte)code;
        }
        byte[] block = this.block;
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        block1: while (i < npix) {
            if (count == 0) {
                count = this.readBlock();
                if (count <= 0) {
                    this.status = 3;
                    break;
                }
                bi = 0;
            }
            datum += (block[bi] & 0xFF) << bits;
            bits += 8;
            ++bi;
            --count;
            while (bits >= codeSize) {
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = -1;
                    continue;
                }
                if (code == endOfInformation) continue block1;
                if (oldCode == -1) {
                    pixelStack[top] = suffix[code];
                    ++top;
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code >= available) {
                    pixelStack[top] = (byte)first;
                    ++top;
                    code = oldCode;
                }
                while (code >= clear) {
                    pixelStack[top] = suffix[code];
                    ++top;
                    code = prefix[code];
                }
                first = suffix[code] & 0xFF;
                mainPixels[pi] = (byte)first;
                ++pi;
                ++i;
                while (top > 0) {
                    mainPixels[pi] = pixelStack[--top];
                    ++pi;
                    ++i;
                }
                if (available < 4096) {
                    prefix[available] = (short)oldCode;
                    suffix[available] = (byte)first;
                    if ((++available & codeMask) == 0 && available < 4096) {
                        ++codeSize;
                        codeMask += available;
                    }
                }
                oldCode = inCode;
            }
        }
        Arrays.fill(mainPixels, pi, npix, (byte)0);
    }

    private int readByte() {
        return this.rawData.get() & 0xFF;
    }

    private int readBlock() {
        int blockSize = this.readByte();
        if (blockSize <= 0) {
            return blockSize;
        }
        this.rawData.get(this.block, 0, Math.min(blockSize, this.rawData.remaining()));
        return blockSize;
    }

    private Bitmap getNextBitmap() {
        Bitmap.Config config = this.isFirstFrameTransparent == null || this.isFirstFrameTransparent != false ? Bitmap.Config.ARGB_8888 : this.bitmapConfig;
        Bitmap result = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, config);
        result.setHasAlpha(true);
        return result;
    }
}

