/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.gsm;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import threegpp.charset.gsm.GSMCharset;

public class GSMEncoder
extends CharsetEncoder {
    private static final float AVG_BYTES_PER_CHAR = 1.0f;
    private static final float MAX_BYTES_PER_CHAR = 2.0f;
    private int nextByteToSave = -1;

    protected GSMEncoder(GSMCharset cs) {
        super(cs, 1.0f, 2.0f);
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        if (this.alreadyHaveNextByte()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            this.saveNextByte(out);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.nextByteToSave = -1;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (this.alreadyHaveNextByte()) {
                this.saveNextByte(out);
                continue;
            }
            int code = this.char2GSMCode(in.get());
            if (code == -1) {
                return CoderResult.unmappableForLength(in.position());
            }
            this.saveNextByte(code, out);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    public boolean canEncode(char c) {
        return this.char2GSMCode(c) != -1;
    }

    @Override
    public boolean canEncode(CharSequence cs) {
        for (int i = 0; i < cs.length(); ++i) {
            if (this.canEncode(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private int char2GSMCode(int ch) {
        if (ch == 65535) {
            return -1;
        }
        int result = "@\u00a3$\u00a5\u00e8\u00e9\u00f9\u00ec\u00f2\u00c7\n\u00d8\u00f8\r\u00c5\u00e5\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\uffff\u00c6\u00e6\u00df\u00c9 !\"#\u00a4%&'()*+,-./0123456789:;<=>?\u00a1ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00d1\u00dc\u00a7\u00bfabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00f1\u00fc\u00e0".indexOf(ch);
        if (result == -1 && (result = "          \n         ^                   {}     \\            [~] |                                    \u20ac                          ".indexOf(ch)) != -1) {
            result = GSMEncoder.setEscapeFlag(result);
        }
        return result;
    }

    private static int setEscapeFlag(int code) {
        return code | 0x80;
    }

    private static int clearEscapeFlag(int code) {
        return code & 0xFFFFFF7F;
    }

    private static boolean shouldBeEscaped(int code) {
        return (code & 0x80) != 0;
    }

    private boolean alreadyHaveNextByte() {
        return this.nextByteToSave != -1;
    }

    private void saveNextByte(ByteBuffer out) {
        out.put((byte)this.nextByteToSave);
        this.nextByteToSave = -1;
    }

    private void saveNextByte(int code, ByteBuffer out) {
        if (GSMEncoder.shouldBeEscaped(code)) {
            this.nextByteToSave = GSMEncoder.clearEscapeFlag(code);
            out.put((byte)27);
        } else {
            out.put((byte)code);
        }
    }
}

