/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import threegpp.charset.TelecomCharsetDecoder;
import threegpp.charset.gsm.GSMCharset;
import threegpp.charset.ucs2.UCS2Charset80;
import threegpp.charset.ucs2.UCS2Charset81;

public class TelecomCharset
extends Charset {
    private static final String CANONICAL_NAME = "X-GSM-UCS2";
    private static final String[] ALIASES = new String[]{"ANY-TELECOM", "TELECOM", "GSM-OR-UCS2"};

    public TelecomCharset() {
        super(CANONICAL_NAME, ALIASES);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof GSMCharset || cs instanceof UCS2Charset80 || cs instanceof UCS2Charset81 || cs instanceof TelecomCharset;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new TelecomCharsetDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canEncode() {
        return false;
    }
}

