/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheWithGhostCache;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.typesafe.config.Config;

@Policy.PolicySpec(name="sketch.TinyCache_GhostCache")
public final class TinyCacheWithGhostCachePolicy
implements Policy.KeyOnlyPolicy {
    private final TinyCacheWithGhostCache tinyCache;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);

    public TinyCacheWithGhostCachePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        int maximumSize = Math.toIntExact(settings.maximumSize());
        this.tinyCache = new TinyCacheWithGhostCache((int)Math.ceil((double)maximumSize / 64.0), 64, settings.randomSeed());
    }

    @Override
    public void record(long key) {
        if (this.tinyCache.contains(key)) {
            this.tinyCache.recordItem(key);
            this.policyStats.recordHit();
        } else {
            boolean evicted = this.tinyCache.addItem(key);
            this.tinyCache.recordItem(key);
            this.policyStats.recordMiss();
            if (evicted) {
                this.policyStats.recordEviction();
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

