/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.typesafe.config.Config;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;

@Policy.PolicySpec(name="product.Ehcache3")
public final class Ehcache3Policy
implements Policy.KeyOnlyPolicy {
    private final Cache<Long, Boolean> cache;
    private final CacheManager cacheManager;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);
    private final CacheStatistics stats;

    public Ehcache3Policy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        DefaultStatisticsService statistics = new DefaultStatisticsService();
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().using((Service)new SameThreadExecutionService()).using((Service)statistics).build(true);
        this.cache = this.cacheManager.createCache("ehcache3", CacheConfigurationBuilder.newCacheConfigurationBuilder(Long.class, Boolean.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(settings.maximumSize(), (ResourceUnit)EntryUnit.ENTRIES)).build());
        this.cache.getRuntimeConfiguration().registerCacheEventListener(event -> this.policyStats.recordEviction(), EventOrdering.ORDERED, EventFiring.SYNCHRONOUS, EventType.EVICTED, new EventType[0]);
        this.stats = statistics.getCacheStatistics("ehcache3");
    }

    @Override
    public void record(long key) {
        Boolean value = (Boolean)this.cache.get((Object)key);
        if (value == null) {
            this.cache.put((Object)key, (Object)Boolean.TRUE);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cacheManager.close();
        Preconditions.checkState((this.policyStats.hitCount() == this.stats.getCacheHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == this.stats.getCacheMisses() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.evictionCount() == this.stats.getCacheEvictions() ? 1 : 0) != 0);
    }

    private static final class SameThreadExecutionService
    implements ExecutionService {
        private SameThreadExecutionService() {
        }

        public ScheduledExecutorService getScheduledExecutor(String alias) {
            throw new UnsupportedOperationException();
        }

        public ExecutorService getOrderedExecutor(String alias, BlockingQueue<Runnable> queue) {
            return MoreExecutors.newDirectExecutorService();
        }

        public ExecutorService getUnorderedExecutor(String alias, BlockingQueue<Runnable> queue) {
            return MoreExecutors.newDirectExecutorService();
        }

        public void start(ServiceProvider<Service> provider) {
        }

        public void stop() {
        }
    }
}

