/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.membership.bloom;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import org.fastfilter.Filter;
import org.fastfilter.FilterType;

public final class FastFilter
implements Membership {
    private final FilterType filterType;
    private final int bitsPerKey;
    private final long[] keys;
    private Filter filter;

    public FastFilter(Config config) {
        FastFilterSettings settings = new FastFilterSettings(config);
        this.keys = new long[(int)settings.membership().expectedInsertions()];
        this.filterType = settings.filterType();
        this.bitsPerKey = settings.bitsPerKey();
        this.reset();
    }

    @Override
    public boolean mightContain(long e) {
        return this.filter.mayContain(e);
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public boolean put(long e) {
        if (this.filter.mayContain(e)) {
            return false;
        }
        this.filter.add(e);
        return true;
    }

    private void reset() {
        this.filter = this.filterType.construct(this.keys, this.bitsPerKey);
        Preconditions.checkState((boolean)this.filter.supportsAdd(), (Object)"Filter must support additions");
    }

    static final class FastFilterSettings
    extends BasicSettings {
        public FastFilterSettings(Config config) {
            super(config);
        }

        public FilterType filterType() {
            String type = this.config().getString("membership.fast-filter.type");
            return FilterType.valueOf((String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, type));
        }

        public int bitsPerKey() {
            return this.config().getInt("membership.fast-filter.bits-per-key");
        }
    }
}

