/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nearcache.NearCacheStats;
import com.hazelcast.partition.PartitioningStrategy;
import com.typesafe.config.Config;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="product.Hazelcast")
public final class HazelcastPolicy
implements Policy.KeyOnlyPolicy {
    private final NearCache<Long, Boolean> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;

    public HazelcastPolicy(HazelcastSettings settings, EvictionPolicy policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, policy.name()));
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        NearCacheConfig config = new NearCacheConfig().setSerializeKeys(false).setInMemoryFormat(InMemoryFormat.OBJECT).setEvictionConfig(new EvictionConfig().setMaxSizePolicy(MaxSizePolicy.ENTRY_COUNT).setEvictionPolicy(policy).setSize(this.maximumSize));
        this.cache = new DefaultNearCache("simulation", config, (SerializationService)DummySerializationService.INSTANCE, null, this.getClass().getClassLoader(), null);
        this.cache.initialize();
    }

    public static Set<Policy> policies(Config config) {
        HazelcastSettings settings = new HazelcastSettings(config);
        return settings.policy().stream().map(policy -> new HazelcastPolicy(settings, (EvictionPolicy)policy)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            if (this.cache.size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, null, (Object)Boolean.TRUE, null);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        NearCacheStats stats = this.cache.getNearCacheStats();
        this.cache.destroy();
        Preconditions.checkState((stats.getOwnedEntryCount() <= (long)this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((stats.getHits() == this.policyStats.hitCount() ? 1 : 0) != 0);
        Preconditions.checkState((stats.getMisses() == this.policyStats.missCount() ? 1 : 0) != 0);
        Preconditions.checkState((stats.getEvictions() == this.policyStats.evictionCount() ? 1 : 0) != 0);
    }

    static enum DummySerializationService implements SerializationService
    {
        INSTANCE;


        public <B extends Data> B toData(Object obj) {
            return (B)((Data)obj);
        }

        public <B extends Data> B toDataWithSchema(Object obj) {
            return (B)((Data)obj);
        }

        public <B extends Data> B toData(Object obj, PartitioningStrategy strategy) {
            return (B)((Data)obj);
        }

        public <T> T toObject(Object data) {
            return (T)data;
        }

        public <T> T toObject(Object data, Class klazz) {
            return (T)data;
        }

        public ManagedContext getManagedContext() {
            return null;
        }

        public <B extends Data> B trimSchema(Data data) {
            return (B)data;
        }
    }

    static final class HazelcastSettings
    extends BasicSettings {
        public HazelcastSettings(Config config) {
            super(config);
        }

        public Set<EvictionPolicy> policy() {
            EnumSet<EvictionPolicy> policies = EnumSet.noneOf(EvictionPolicy.class);
            for (String policy : this.config().getStringList("hazelcast.policy")) {
                Optional option = Enums.getIfPresent(EvictionPolicy.class, (String)policy.toUpperCase(Locale.US)).toJavaUtil();
                option.ifPresentOrElse(policies::add, () -> {
                    throw new IllegalArgumentException("Unknown policy: " + policy);
                });
            }
            return policies;
        }
    }
}

