/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.ClimberResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.IncrementalResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.IndicatorResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.PeriodicResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin64.CountMin64TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.admission.perfect.PerfectFrequency;
import com.github.benmanes.caffeine.cache.simulator.admission.table.RandomRemovalFrequencyTable;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheAdapter;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.typesafe.config.Config;

public final class TinyLfu
implements Admittor.KeyOnlyAdmittor {
    private final PolicyStats policyStats;
    private final Frequency sketch;

    public TinyLfu(Config config, PolicyStats policyStats) {
        this.policyStats = policyStats;
        this.sketch = this.makeSketch(config);
    }

    private Frequency makeSketch(Config config) {
        BasicSettings settings = new BasicSettings(config);
        String type = settings.tinyLfu().sketch();
        if (type.equalsIgnoreCase("count-min-4")) {
            String reset = settings.tinyLfu().countMin4().reset();
            if (reset.equalsIgnoreCase("periodic")) {
                return new PeriodicResetCountMin4(config);
            }
            if (reset.equalsIgnoreCase("incremental")) {
                return new IncrementalResetCountMin4(config);
            }
            if (reset.equalsIgnoreCase("climber")) {
                return new ClimberResetCountMin4(config);
            }
            if (reset.equalsIgnoreCase("indicator")) {
                return new IndicatorResetCountMin4(config);
            }
        } else {
            if (type.equalsIgnoreCase("count-min-64")) {
                return new CountMin64TinyLfu(config);
            }
            if (type.equalsIgnoreCase("random-table")) {
                return new RandomRemovalFrequencyTable(config);
            }
            if (type.equalsIgnoreCase("tiny-table")) {
                return new TinyCacheAdapter(config);
            }
            if (type.equalsIgnoreCase("perfect-table")) {
                return new PerfectFrequency(config);
            }
        }
        throw new IllegalStateException("Unknown sketch type: " + type);
    }

    public int frequency(long key) {
        return this.sketch.frequency(key);
    }

    @Override
    public void record(long key) {
        this.sketch.increment(key);
    }

    @Override
    public boolean admit(long candidateKey, long victimKey) {
        this.sketch.reportMiss();
        long candidateFreq = this.sketch.frequency(candidateKey);
        long victimFreq = this.sketch.frequency(victimKey);
        if (candidateFreq > victimFreq) {
            this.policyStats.recordAdmission();
            return true;
        }
        this.policyStats.recordRejection();
        return false;
    }
}

