/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission;

import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.typesafe.config.Config;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public enum Admission {
    ALWAYS((config, policyStats) -> Admittor.always(), UnaryOperator.identity()),
    TINYLFU(TinyLfu::new, name -> name + "_TinyLfu");

    private final BiFunction<Config, PolicyStats, Admittor> factory;
    private final Function<String, String> formatter;

    private Admission(BiFunction<Config, PolicyStats, Admittor> factory, UnaryOperator<String> formatter) {
        this.formatter = formatter;
        this.factory = factory;
    }

    public Admittor from(Config config, PolicyStats policyStats) {
        return this.factory.apply(config, policyStats);
    }

    public String format(String name) {
        return this.formatter.apply(name);
    }
}

