/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class Simulator {
    private final BasicSettings settings;

    public Simulator(Config config) {
        this.settings = new BasicSettings(config.getConfig("caffeine.simulator"));
    }

    public void run() {
        block3: {
            TraceReader trace = this.getTraceReader(this.settings);
            ImmutableList<PolicyActor> policies = this.getPolicyActors(trace.characteristics());
            if (policies.isEmpty()) {
                System.err.println("No active policies in the current configuration");
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                this.broadcast((List<PolicyActor>)policies, trace);
                this.report((List<PolicyActor>)policies, trace.characteristics());
                System.out.println("Executed in " + stopwatch);
            }
            catch (RuntimeException e) {
                if (Thread.currentThread().isInterrupted()) break block3;
                throw e;
            }
        }
    }

    private void broadcast(List<PolicyActor> policies, TraceReader trace) {
        long skip = this.settings.trace().skip();
        long limit = this.settings.trace().limit();
        int batchSize = this.settings.actor().batchSize();
        try (Stream<AccessEvent> events = trace.events().skip(skip).limit(limit);){
            ArrayList batch = new ArrayList(batchSize);
            events.forEach(event -> {
                batch.add(event);
                if (batch.size() == batchSize) {
                    List<AccessEvent> accessEvents = List.copyOf(batch);
                    for (PolicyActor policy : policies) {
                        policy.send(accessEvents);
                    }
                    batch.clear();
                }
            });
            List<AccessEvent> remainder = List.copyOf(batch);
            for (PolicyActor policy : policies) {
                policy.send(remainder);
            }
            CompletableFuture[] futures = (CompletableFuture[])policies.stream().map(PolicyActor::finish).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
        }
    }

    private void report(List<PolicyActor> policies, Set<Policy.Characteristic> characteristics) {
        Reporter reporter = this.settings.report().format().create(this.settings.config(), characteristics);
        ImmutableList results = (ImmutableList)policies.stream().map(PolicyActor::stats).collect(ImmutableList.toImmutableList());
        reporter.print((List<PolicyStats>)results);
    }

    private TraceReader getTraceReader(BasicSettings settings) {
        if (settings.trace().isSynthetic()) {
            return Synthetic.generate(settings.trace());
        }
        List<String> filePaths = settings.trace().traceFiles().paths();
        TraceFormat format = settings.trace().traceFiles().format();
        return format.readFiles(filePaths);
    }

    private ImmutableList<PolicyActor> getPolicyActors(Set<Policy.Characteristic> characteristics) {
        Registry registry = new Registry(this.settings, characteristics);
        return (ImmutableList)registry.policies().stream().map(policy -> new PolicyActor(Thread.currentThread(), (Policy)policy, this.settings)).collect(ImmutableList.toImmutableList());
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        new Simulator(ConfigFactory.load()).run();
    }
}

