/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin4;

import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.ClimberResetCountMin4;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.Indicator;
import com.typesafe.config.Config;

public final class IndicatorResetCountMin4
implements Frequency {
    private final ClimberResetCountMin4 sketch;
    int prevHintSum;
    int prevHintCount;
    Indicator indicator;

    public IndicatorResetCountMin4(Config config) {
        this.sketch = new ClimberResetCountMin4(config);
        this.indicator = new Indicator(config);
    }

    @Override
    public int frequency(long e) {
        return this.sketch.frequency(e);
    }

    @Override
    public void increment(long e) {
        this.sketch.increment(e);
        this.indicator.record(e);
    }

    @Override
    public void reportMiss() {
        if (this.sketch.getEventsToCount() <= 0) {
            this.sketch.resetEventsToCount();
            double ind = this.getIndicator();
            this.sketch.setStep(this.hintToStep(ind));
            this.indicator.reset();
        }
    }

    private double getIndicator() {
        return this.indicator.getIndicator();
    }

    private int hintToStep(double ind) {
        return (int)(ind * 30.0);
    }

    public int getEventsToCount() {
        return this.sketch.getEventsToCount();
    }

    public int getPeriod() {
        return this.sketch.getPeriod();
    }

    public int getHintSum() {
        return this.prevHintSum;
    }

    public int getHintCount() {
        return this.prevHintCount;
    }
}

