/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin4;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.CountMin4;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.typesafe.config.Config;

public final class ClimberResetCountMin4
extends CountMin4 {
    static final long ONE_MASK = 0x1111111111111111L;
    final Membership doorkeeper;
    int additions;
    int period;
    int prevMisses;
    int misses;
    int direction = 1;
    int eventsToCount;

    public ClimberResetCountMin4(Config config) {
        super(config);
        BasicSettings settings = new BasicSettings(config);
        this.doorkeeper = settings.tinyLfu().countMin4().periodic().doorkeeper().enabled() ? settings.membership().filter().create(config) : Membership.disabled();
    }

    @Override
    protected void ensureCapacity(long maximumSize) {
        super.ensureCapacity(maximumSize);
        int n = this.period = maximumSize == 0L ? 10 : 10 * this.table.length;
        if (this.period <= 0) {
            this.period = Integer.MAX_VALUE;
        }
        this.eventsToCount = this.period;
    }

    @Override
    public int frequency(long e) {
        int count = super.frequency(e);
        if (this.doorkeeper.mightContain(e)) {
            ++count;
        }
        return Math.min(count, 15);
    }

    @Override
    public void increment(long e) {
        --this.eventsToCount;
        if (!this.doorkeeper.put(e)) {
            super.increment(e);
        }
    }

    @Override
    protected void tryReset(boolean added) {
        this.additions += this.step;
        if (!added) {
            return;
        }
        if (this.additions < this.period) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.additions = (this.additions >>> 1) - (count >>> 2);
        this.doorkeeper.clear();
    }

    @Override
    public void reportMiss() {
        ++this.misses;
        if (this.eventsToCount <= 0) {
            this.eventsToCount = this.period;
            if (this.misses > this.prevMisses) {
                this.direction = -1 * this.direction;
            }
            this.step -= this.direction;
            this.prevMisses = this.misses;
            this.misses = 0;
            if (this.step < 1) {
                this.step = 1;
            } else if (this.step > 15) {
                this.step = 15;
            }
        }
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int x) {
        this.step = Math.max(1, Math.min(15, this.step));
    }

    public int getEventsToCount() {
        return this.eventsToCount;
    }

    public void resetEventsToCount() {
        this.eventsToCount = this.period;
    }

    public int getPeriod() {
        return this.period;
    }
}

