/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.filter.reactive;

import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.reactive.ReactiveFilterChain;
import com.giffing.bucket4j.spring.boot.starter.filter.reactive.ReactiveRateLimitException;
import io.github.bucket4j.ConsumptionProbe;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AbstractReactiveFilter {
    private static final Logger log = LoggerFactory.getLogger(AbstractReactiveFilter.class);
    private FilterConfiguration<ServerHttpRequest> filterConfig;

    public AbstractReactiveFilter(FilterConfiguration<ServerHttpRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void setFilterConfig(FilterConfiguration<ServerHttpRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected boolean urlMatches(ServerHttpRequest request) {
        return request.getURI().getPath().matches(this.filterConfig.getUrl());
    }

    protected Mono<Void> chainWithRateLimitCheck(ServerWebExchange exchange, ReactiveFilterChain chain) {
        log.debug("reate-limit-check;method:{};uri:{}", (Object)exchange.getRequest().getMethod(), (Object)exchange.getRequest().getURI());
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        ArrayList<Mono> asyncConsumptionProbes = new ArrayList<Mono>();
        for (RateLimitCheck rlc : this.filterConfig.getRateLimitChecks()) {
            ConsumptionProbeHolder cph = rlc.rateLimit((Object)request);
            if (cph == null || cph.getConsumptionProbeCompletableFuture() == null) continue;
            asyncConsumptionProbes.add(Mono.fromFuture((CompletableFuture)cph.getConsumptionProbeCompletableFuture()));
            if (this.filterConfig.getStrategy() != RateLimitConditionMatchingStrategy.FIRST) continue;
            break;
        }
        if (asyncConsumptionProbes.isEmpty()) {
            return chain.apply(exchange);
        }
        return Flux.concat(asyncConsumptionProbes).reduce(this::reduceConsumptionProbe).flatMap(consumptionProbe -> this.handleConsumptionProbe(exchange, chain, response, (ConsumptionProbe)consumptionProbe));
    }

    protected ConsumptionProbe reduceConsumptionProbe(ConsumptionProbe x, ConsumptionProbe y) {
        ConsumptionProbe result = !x.isConsumed() ? x : (!y.isConsumed() ? y : (x.getRemainingTokens() < y.getRemainingTokens() ? x : y));
        log.debug("reduce-probes;result-isConsumed:{};result-getremainingTokens:{};x-isConsumed:{};x-getremainingTokens{};y-isConsumed:{};y-getremainingTokens{}", new Object[]{result.isConsumed(), result.getRemainingTokens(), x.isConsumed(), x.getRemainingTokens(), y.isConsumed(), y.getRemainingTokens()});
        return result;
    }

    protected Mono<Void> handleConsumptionProbe(ServerWebExchange exchange, ReactiveFilterChain chain, ServerHttpResponse response, ConsumptionProbe cp) {
        log.debug("probe-results;isConsumed:{};remainingTokens:{};nanosToWaitForRefill:{};nanosToWaitForReset:{}", new Object[]{cp.isConsumed(), cp.getRemainingTokens(), cp.getNanosToWaitForRefill(), cp.getNanosToWaitForReset()});
        if (!cp.isConsumed()) {
            if (Boolean.FALSE.equals(this.filterConfig.getHideHttpResponseHeaders())) {
                this.filterConfig.getHttpResponseHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)response.getHeaders()).addIfAbsent(arg_0, arg_1));
            }
            if (this.filterConfig.getHttpResponseBody() != null) {
                response.setStatusCode((HttpStatusCode)this.filterConfig.getHttpStatusCode());
                response.getHeaders().set("Content-Type", this.filterConfig.getHttpContentType());
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(this.filterConfig.getHttpResponseBody().getBytes(StandardCharsets.UTF_8));
                return response.writeWith((Publisher)Flux.just((Object)buffer));
            }
            return Mono.error((Throwable)((Object)new ReactiveRateLimitException("HTTP ResponseBody is null")));
        }
        if (Boolean.FALSE.equals(this.filterConfig.getHideHttpResponseHeaders())) {
            log.debug("header;X-Rate-Limit-Remaining:{}", (Object)cp.getRemainingTokens());
            response.getHeaders().set("X-Rate-Limit-Remaining", String.valueOf(cp.getRemainingTokens()));
        }
        return chain.apply(exchange);
    }

    public FilterConfiguration<ServerHttpRequest> getFilterConfig() {
        return this.filterConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractReactiveFilter)) {
            return false;
        }
        AbstractReactiveFilter other = (AbstractReactiveFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterConfiguration<ServerHttpRequest> this$filterConfig = this.getFilterConfig();
        FilterConfiguration<ServerHttpRequest> other$filterConfig = other.getFilterConfig();
        return !(this$filterConfig == null ? other$filterConfig != null : !this$filterConfig.equals(other$filterConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractReactiveFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterConfiguration<ServerHttpRequest> $filterConfig = this.getFilterConfig();
        result = result * 59 + ($filterConfig == null ? 43 : $filterConfig.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractReactiveFilter(filterConfig=" + this.getFilterConfig() + ")";
    }
}

