/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.metrics.actuator;

import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Endpoint.class})
public class Bucket4jEndpoint {

    @Configuration
    @Endpoint(id="bucket4j")
    public static class Bucket4jEndpointConfig {
        @Autowired(required=false)
        @Qualifier(value="SERVLET")
        private Bucket4jConfigurationHolder servletConfigs;
        @Autowired(required=false)
        @Qualifier(value="WEBFLUX")
        private Bucket4jConfigurationHolder webfluxConfigs;
        @Autowired(required=false)
        @Qualifier(value="GATEWAY")
        private Bucket4jConfigurationHolder gatewayConfigs;

        @ReadOperation
        public Map<String, Object> bucket4jConfig() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (this.servletConfigs != null) {
                result.put("servlet", this.servletConfigs.getFilterConfiguration());
            }
            if (this.webfluxConfigs != null) {
                result.put("webflux", this.webfluxConfigs.getFilterConfiguration());
            }
            if (this.gatewayConfigs != null) {
                result.put("gateway", this.gatewayConfigs.getFilterConfiguration());
            }
            return result;
        }
    }
}

