/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.webflux;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import com.giffing.bucket4j.spring.boot.starter.config.filter.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.predicate.WebfluxExecutePredicateConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.webflux.Bucket4JAutoConfigurationWebfluxFilterBeans;
import com.giffing.bucket4j.spring.boot.starter.config.metrics.actuator.SpringBootActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.reactive.webflux.WebfluxWebFilter;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.WebFilter;

@Configuration
@ConditionalOnClass(value={WebFilter.class})
@ConditionalOnProperty(prefix="bucket4j", value={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={WebFluxAutoConfiguration.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={AsyncCacheResolver.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@Import(value={WebfluxExecutePredicateConfiguration.class, Bucket4JAutoConfigurationWebfluxFilterBeans.class, SpringBootActuatorConfig.class})
public class Bucket4JAutoConfigurationWebfluxFilter
extends Bucket4JBaseConfiguration<ServerHttpRequest> {
    private final Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationWebfluxFilter.class);
    private final Bucket4JBootProperties properties;
    private final ConfigurableBeanFactory beanFactory;
    private final GenericApplicationContext context;
    private final AsyncCacheResolver cacheResolver;
    private final List<MetricHandler> metricHandlers;
    private final Map<String, ExecutePredicate<ServerHttpRequest>> executePredicates;
    private final Bucket4jConfigurationHolder servletConfigurationHolder;
    private final ExpressionParser webfluxFilterExpressionParser;

    public Bucket4JAutoConfigurationWebfluxFilter(Bucket4JBootProperties properties, ConfigurableBeanFactory beanFactory, GenericApplicationContext context, AsyncCacheResolver cacheResolver, List<MetricHandler> metricHandlers, List<ExecutePredicate<ServerHttpRequest>> executePredicates, Bucket4jConfigurationHolder servletConfigurationHolder, ExpressionParser webfluxFilterExpressionParser, Optional<CacheManager<String, Bucket4JConfiguration>> configCacheManager) {
        super(configCacheManager.orElse(null));
        this.properties = properties;
        this.beanFactory = beanFactory;
        this.context = context;
        this.cacheResolver = cacheResolver;
        this.metricHandlers = metricHandlers;
        this.executePredicates = executePredicates.stream().collect(Collectors.toMap(ExecutePredicate::name, Function.identity()));
        this.servletConfigurationHolder = servletConfigurationHolder;
        this.webfluxFilterExpressionParser = webfluxFilterExpressionParser;
    }

    @PostConstruct
    public void initFilters() {
        AtomicInteger filterCount = new AtomicInteger(0);
        this.properties.getFilters().stream().filter(filter -> StringUtils.hasText((String)filter.getUrl()) && filter.getFilterMethod().equals((Object)FilterMethod.WEBFLUX)).map(filter -> this.properties.isFilterConfigCachingEnabled() ? this.getOrUpdateConfigurationFromCache((Bucket4JConfiguration)filter) : filter).forEach(filter -> {
            this.addDefaultMetricTags(this.properties, (Bucket4JConfiguration)filter);
            filterCount.incrementAndGet();
            FilterConfiguration filterConfig = this.buildFilterConfig((Bucket4JConfiguration)filter, this.cacheResolver.resolve(filter.getCacheName()), this.webfluxFilterExpressionParser, this.beanFactory);
            this.servletConfigurationHolder.addFilterConfiguration(filter);
            Object beanName = filter.getId() != null ? filter.getId() : "bucket4JWebfluxFilter" + filterCount;
            this.context.registerBean((String)beanName, WebFilter.class, () -> new WebfluxWebFilter((FilterConfiguration<ServerHttpRequest>)filterConfig), new BeanDefinitionCustomizer[0]);
            this.log.info("create-webflux-filter;{};{};{}", new Object[]{filterCount, filter.getCacheName(), filter.getUrl()});
        });
    }

    @Override
    public List<MetricHandler> getMetricHandlers() {
        return this.metricHandlers;
    }

    @Override
    protected ExecutePredicate<ServerHttpRequest> getExecutePredicateByName(String name) {
        return this.executePredicates.getOrDefault(name, null);
    }

    @Override
    public void onCacheUpdateEvent(CacheUpdateEvent<String, Bucket4JConfiguration> event) {
        Bucket4JConfiguration newConfig = event.getNewValue();
        if (newConfig.getFilterMethod().equals((Object)FilterMethod.WEBFLUX)) {
            try {
                WebfluxWebFilter filter = (WebfluxWebFilter)this.context.getBean(event.getKey(), WebfluxWebFilter.class);
                FilterConfiguration newFilterConfig = this.buildFilterConfig(newConfig, this.cacheResolver.resolve(newConfig.getCacheName()), this.webfluxFilterExpressionParser, this.beanFactory);
                filter.setFilterConfig(newFilterConfig);
            }
            catch (Exception exception) {
                this.log.warn("Failed to update Webflux Filter configuration. {}", (Object)exception.getMessage());
            }
        }
    }
}

