/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.predicate;

import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MethodExecutePredicate<T>
extends ExecutePredicate<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodExecutePredicate.class);
    private List<String> methods = new ArrayList<String>();

    public boolean testRequestMethod(String requestMethod) {
        Optional<String> matches = this.methods.stream().filter(m -> m.equalsIgnoreCase(requestMethod)).findFirst();
        log.debug("method-predicate;methods:{};value:{},result:{}", new Object[]{this.methods, requestMethod, matches.isPresent()});
        return matches.isPresent();
    }

    public String name() {
        return "METHOD";
    }

    public ExecutePredicate<T> parseSimpleConfig(String simpleConfig) {
        this.methods = Arrays.stream(simpleConfig.split(",")).map(String::trim).toList();
        return this;
    }
}

