/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.Condition;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicateDefinition;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricBucketListener;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagResult;
import com.giffing.bucket4j.spring.boot.starter.context.properties.BandWidth;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MetricTag;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.exception.ExecutePredicateInstantiationException;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public abstract class Bucket4JBaseConfiguration<R>
implements CacheUpdateListener<String, Bucket4JConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(Bucket4JBaseConfiguration.class);
    private final CacheManager<String, Bucket4JConfiguration> configCacheManager;

    public Bucket4JBaseConfiguration(CacheManager<String, Bucket4JConfiguration> configCacheManager) {
        this.configCacheManager = configCacheManager;
    }

    public abstract List<MetricHandler> getMetricHandlers();

    public FilterConfiguration<R> buildFilterConfig(Bucket4JConfiguration config, ProxyManagerWrapper proxyWrapper, ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory) {
        FilterConfiguration<R> filterConfig = this.mapFilterConfiguration(config);
        config.getRateLimits().forEach(rl -> {
            log.debug("RL: {}", (Object)rl.toString());
            ConfigurationBuilder configurationBuilder = this.prepareBucket4jConfigurationBuilder((RateLimit)rl);
            Predicate<R> executionPredicate = this.prepareExecutionPredicates((RateLimit)rl);
            Predicate<R> skipPredicate = this.prepareSkipPredicates((RateLimit)rl);
            BucketConfiguration bucketConfiguration = configurationBuilder.build();
            RateLimitCheck rlc = servletRequest -> {
                boolean skipRateLimit = this.performSkipRateLimitCheck(expressionParser, beanFactory, (RateLimit)rl, executionPredicate, skipPredicate, (R)servletRequest);
                if (!skipRateLimit) {
                    String key = this.getKeyFilter(filterConfig.getUrl(), (RateLimit)rl, expressionParser, (BeanFactory)beanFactory).key(servletRequest);
                    MetricBucketListener metricBucketListener = this.createMetricListener(config.getCacheName(), expressionParser, beanFactory, filterConfig, servletRequest);
                    log.debug("try-and-consume;key:{};tokens:{}", (Object)key, (Object)rl.getNumTokens());
                    long configVersion = config.getBucket4JVersionNumber();
                    return proxyWrapper.tryConsumeAndReturnRemaining(key, rl.getNumTokens(), bucketConfiguration, metricBucketListener, configVersion, rl.getTokensInheritanceStrategy());
                }
                return null;
            };
            filterConfig.addRateLimitCheck(rlc);
        });
        return filterConfig;
    }

    private FilterConfiguration<R> mapFilterConfiguration(Bucket4JConfiguration config) {
        FilterConfiguration filterConfig = new FilterConfiguration();
        filterConfig.setUrl(config.getUrl().strip());
        filterConfig.setOrder(config.getFilterOrder().intValue());
        filterConfig.setStrategy(config.getStrategy());
        filterConfig.setHttpContentType(config.getHttpContentType());
        filterConfig.setHttpResponseBody(config.getHttpResponseBody());
        filterConfig.setHttpStatusCode(config.getHttpStatusCode());
        filterConfig.setHideHttpResponseHeaders(config.getHideHttpResponseHeaders());
        filterConfig.setHttpResponseHeaders(config.getHttpResponseHeaders());
        filterConfig.setMetrics(config.getMetrics());
        return filterConfig;
    }

    private boolean performSkipRateLimitCheck(ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory, RateLimit rl, Predicate<R> executionPredicate, Predicate<R> skipPredicate, R servletRequest) {
        boolean skipRateLimit = false;
        if (rl.getSkipCondition() != null) {
            skipRateLimit = this.skipCondition(rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
            log.debug("skip-rate-limit - skip-condition: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit) {
            skipRateLimit = skipPredicate.test(servletRequest);
            log.debug("skip-rate-limit - skip-predicates: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit && rl.getExecuteCondition() != null) {
            skipRateLimit = !this.executeCondition(rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
            log.debug("skip-rate-limit - execute-condition: {}", (Object)skipRateLimit);
        }
        if (!skipRateLimit) {
            skipRateLimit = !executionPredicate.test(servletRequest);
            log.debug("skip-rate-limit - execute-predicates: {}", (Object)skipRateLimit);
        }
        return skipRateLimit;
    }

    protected abstract ExecutePredicate<R> getExecutePredicateByName(String var1);

    private ConfigurationBuilder prepareBucket4jConfigurationBuilder(RateLimit rl) {
        ConfigurationBuilder configBuilder = BucketConfiguration.builder();
        for (BandWidth bandWidth : rl.getBandwidths()) {
            BandwidthBuilder.BandwidthBuilderBuildStage bucket4jBandWidth;
            long capacity = bandWidth.getCapacity();
            long refillCapacity = bandWidth.getRefillCapacity() != null ? bandWidth.getRefillCapacity().longValue() : bandWidth.getCapacity();
            Duration refillPeriod = Duration.of(bandWidth.getTime(), bandWidth.getUnit());
            switch (bandWidth.getRefillSpeed()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GREEDY: {
                    BandwidthBuilder.BandwidthBuilderBuildStage bandwidthBuilderBuildStage = Bandwidth.builder().capacity(capacity).refillGreedy(refillCapacity, refillPeriod).id(bandWidth.getId());
                    break;
                }
                case INTERVAL: {
                    BandwidthBuilder.BandwidthBuilderBuildStage bandwidthBuilderBuildStage = bucket4jBandWidth = Bandwidth.builder().capacity(capacity).refillIntervally(refillCapacity, refillPeriod).id(bandWidth.getId());
                }
            }
            if (bandWidth.getInitialCapacity() != null) {
                bucket4jBandWidth = bucket4jBandWidth.initialTokens(bandWidth.getInitialCapacity().longValue());
            }
            configBuilder = configBuilder.addLimit(bucket4jBandWidth.build());
        }
        return configBuilder;
    }

    private MetricBucketListener createMetricListener(String cacheName, ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory, FilterConfiguration<R> filterConfig, R servletRequest) {
        List<MetricTagResult> metricTagResults = this.getMetricTags(expressionParser, beanFactory, filterConfig, servletRequest);
        return new MetricBucketListener(cacheName, this.getMetricHandlers(), filterConfig.getMetrics().getTypes(), metricTagResults);
    }

    private List<MetricTagResult> getMetricTags(ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory, FilterConfiguration<R> filterConfig, R servletRequest) {
        List<MetricTagResult> metricTagResults = filterConfig.getMetrics().getTags().stream().map(metricMetaTag -> {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanFactory));
            Expression expr = expressionParser.parseExpression(metricMetaTag.getExpression());
            String value = (String)expr.getValue((EvaluationContext)context, servletRequest, String.class);
            return new MetricTagResult(metricMetaTag.getKey(), value, metricMetaTag.getTypes());
        }).toList();
        return metricTagResults;
    }

    public KeyFilter<R> getKeyFilter(String url, RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        String cacheKeyexpression = rateLimit.getCacheKey();
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        return request -> {
            Expression expr = expressionParser.parseExpression(cacheKeyexpression);
            String value = (String)expr.getValue((EvaluationContext)context, request, String.class);
            return url + "-" + value;
        };
    }

    public Condition<R> skipCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getSkipCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getSkipCondition());
                return (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
            };
        }
        return null;
    }

    public Condition<R> executeCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getExecuteCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getExecuteCondition());
                return (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
            };
        }
        return null;
    }

    protected void addDefaultMetricTags(Bucket4JBootProperties properties, Bucket4JConfiguration filter) {
        if (!properties.getDefaultMetricTags().isEmpty()) {
            List metricTags = filter.getMetrics().getTags();
            Set filterMetricTagKeys = metricTags.stream().map(MetricTag::getKey).collect(Collectors.toSet());
            properties.getDefaultMetricTags().forEach(defaultTag -> {
                if (!filterMetricTagKeys.contains(defaultTag.getKey())) {
                    metricTags.add(defaultTag);
                }
            });
        }
    }

    private Predicate<R> prepareExecutionPredicates(RateLimit rl) {
        return rl.getExecutePredicates().stream().map(this::createPredicate).reduce(Predicate::and).orElseGet(() -> p -> true);
    }

    private Predicate<R> prepareSkipPredicates(RateLimit rl) {
        return rl.getSkipPredicates().stream().map(this::createPredicate).reduce(Predicate::and).orElseGet(() -> p -> false);
    }

    protected Predicate<R> createPredicate(ExecutePredicateDefinition pd) {
        ExecutePredicate<R> predicate = this.getExecutePredicateByName(pd.getName());
        log.debug("create-predicate;name:{};value:{}", (Object)pd.getName(), (Object)pd.getArgs());
        try {
            ExecutePredicate newPredicateInstance = (ExecutePredicate)predicate.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return newPredicateInstance.init(pd.getArgs());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExecutePredicateInstantiationException(pd.getName(), predicate.getClass());
        }
    }

    protected Bucket4JConfiguration getOrUpdateConfigurationFromCache(Bucket4JConfiguration filter) {
        if (this.configCacheManager == null || filter.getId() == null) {
            return filter;
        }
        Bucket4JConfiguration cachedFilter = this.configCacheManager.getValue(filter.getId());
        if (cachedFilter != null && cachedFilter.getBucket4JVersionNumber() >= filter.getBucket4JVersionNumber()) {
            return cachedFilter;
        }
        this.configCacheManager.setValue(filter.getId(), filter);
        return filter;
    }
}

