/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.failureanalyzer;

import com.giffing.bucket4j.spring.boot.starter.exception.Bucket4jGeneralException;
import com.giffing.bucket4j.spring.boot.starter.exception.ExecutePredicateInstantiationException;
import com.giffing.bucket4j.spring.boot.starter.exception.JCacheNotFoundException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class Bucket4JAutoConfigFailureAnalyzer
extends AbstractFailureAnalyzer<Bucket4jGeneralException> {
    public static final String NEW_LINE = System.getProperty("line.separator");

    protected FailureAnalysis analyze(Throwable rootFailure, Bucket4jGeneralException cause) {
        Bucket4jGeneralException e;
        String descriptionMessage = cause.getMessage();
        Object actionMessage = cause.getMessage();
        if (cause instanceof JCacheNotFoundException) {
            e = (JCacheNotFoundException)cause;
            descriptionMessage = e.getMessage();
            actionMessage = "Cache name: " + ((JCacheNotFoundException)e).getCacheName() + NEW_LINE + "Please configure your caching provider (ehcache, hazelcast, ...)";
        }
        if (cause instanceof ExecutePredicateInstantiationException) {
            e = (ExecutePredicateInstantiationException)cause;
            descriptionMessage = e.getMessage();
            actionMessage = "Please provide a default constructor.";
        }
        return new FailureAnalysis(descriptionMessage, (String)actionMessage, (Throwable)cause);
    }
}

