/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.redis.redisson.cas.RedissonBasedProxyManager;
import java.time.Duration;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonCacheResolver
implements AsyncCacheResolver {
    private final CommandAsyncExecutor commandExecutor;

    public RedissonCacheResolver(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public ProxyManagerWrapper resolve(String cacheName) {
        RedissonBasedProxyManager proxyManager = ((RedissonBasedProxyManager.RedissonBasedProxyManagerBuilder)RedissonBasedProxyManager.builderFor((CommandAsyncExecutor)this.commandExecutor).withExpirationStrategy(ExpirationAfterWriteStrategy.basedOnTimeForRefillingBucketUpToMax((Duration)Duration.ofSeconds(10L)))).build();
        return (key, numTokens, bucketConfiguration, metricsListener, version, replaceStrategy) -> {
            AsyncBucketProxy bucket = proxyManager.asAsync().builder().withImplicitConfigurationReplacement(version, replaceStrategy).build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
            return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
        };
    }
}

