/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import java.io.Serializable;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;

public class RedissonCacheManager<K extends Serializable, V>
implements CacheManager<K, V> {
    private final String cacheName;
    private final RedissonClient redisson;
    private final RTopic pubSubTopic;

    protected RedissonCacheManager(RedissonClient redisson, String cacheName) {
        this.cacheName = cacheName;
        this.redisson = redisson;
        this.pubSubTopic = redisson.getTopic(cacheName);
    }

    @Override
    public V getValue(K key) {
        RMap map = this.redisson.getMap(this.cacheName);
        return (V)map.get(key);
    }

    @Override
    public void setValue(K key, V value) {
        RMap map = this.redisson.getMap(this.cacheName);
        Object oldValue = map.put(key, value);
        if (oldValue != null) {
            CacheUpdateEvent<K, Object> updateEvent = new CacheUpdateEvent<K, Object>(key, oldValue, value);
            this.pubSubTopic.publish(updateEvent);
        }
    }
}

