/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson.RedissonCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson.RedissonCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.redisson.RedissonCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import io.github.bucket4j.redis.redisson.cas.RedissonBasedProxyManager;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={RedissonBasedProxyManager.class})
@ConditionalOnBean(value={CommandAsyncExecutor.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="redis-redisson", matchIfMissing=true)
public class RedissonBucket4jConfiguration {
    private final CommandAsyncExecutor commandExecutor;
    private final RedissonClient redissonClient;
    private final String configCacheName;

    public RedissonBucket4jConfiguration(CommandAsyncExecutor commandExecutor, Bucket4JBootProperties properties) {
        this.commandExecutor = commandExecutor;
        this.configCacheName = properties.getFilterConfigCacheName();
        Config config = new Config(commandExecutor.getServiceManager().getCfg());
        config.useSingleServer().setConnectionMinimumIdleSize(1).setConnectionPoolSize(2);
        this.redissonClient = Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncCacheResolver.class})
    public AsyncCacheResolver bucket4RedisResolver() {
        return new RedissonCacheResolver(this.commandExecutor);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new RedissonCacheManager<String, Bucket4JConfiguration>(this.redissonClient, this.configCacheName);
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public RedissonCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        return new RedissonCacheListener<String, Bucket4JConfiguration>(this.redissonClient, this.configCacheName);
    }
}

