/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.lettuce;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceCacheManager<K, V>
implements CacheManager<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LettuceCacheManager.class);
    private final RedisCommands<String, String> syncCommands;
    private final String cacheName;
    private final Class<V> valueType;
    private final ObjectMapper objectMapper;
    private final String cacheUpdateChannel;

    protected LettuceCacheManager(RedisClient redisClient, String cacheName, Class<V> valueType) {
        this.syncCommands = redisClient.connect().sync();
        this.cacheName = cacheName;
        this.valueType = valueType;
        this.objectMapper = new ObjectMapper();
        this.cacheUpdateChannel = cacheName.concat(":update");
    }

    @Override
    public V getValue(K key) {
        try {
            String serializedValue = (String)this.syncCommands.hget((Object)this.cacheName, (Object)this.objectMapper.writeValueAsString(key));
            return (V)(serializedValue != null ? this.objectMapper.readValue(serializedValue, this.valueType) : null);
        }
        catch (JsonProcessingException e) {
            log.warn("Exception occurred while retrieving key '{}' from cache '{}'. Message: {}", new Object[]{key, this.cacheName, e.getMessage()});
            return null;
        }
    }

    @Override
    public void setValue(K key, V value) {
        try {
            V oldValue = this.getValue(key);
            String serializedKey = this.objectMapper.writeValueAsString(key);
            String serializedValue = this.objectMapper.writeValueAsString(value);
            this.syncCommands.hset((Object)this.cacheName, (Object)serializedKey, (Object)serializedValue);
            if (oldValue != null) {
                CacheUpdateEvent<K, V> updateEvent = new CacheUpdateEvent<K, V>(key, oldValue, value);
                this.syncCommands.publish((Object)this.cacheUpdateChannel, (Object)this.objectMapper.writeValueAsString(updateEvent));
            }
        }
        catch (JsonProcessingException e) {
            log.warn("Exception occurred while setting key '{}' in cache '{}'. Message: {}", new Object[]{key, this.cacheName, e.getMessage()});
            throw new RuntimeException(e);
        }
    }
}

