/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.lettuce;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import io.lettuce.core.RedisClient;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class LettuceCacheListener<K, V>
extends RedisPubSubAdapter<String, String> {
    private static final Logger log = LoggerFactory.getLogger(LettuceCacheListener.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private final String cacheUpdateChannel;
    private final ObjectMapper objectMapper;
    private final JavaType deserializeType;

    public LettuceCacheListener(RedisClient redisClient, String cacheName, Class<K> keyType, Class<V> valueType) {
        this.cacheUpdateChannel = cacheName.concat(":update");
        this.objectMapper = new ObjectMapper();
        this.deserializeType = this.objectMapper.getTypeFactory().constructParametricType(CacheUpdateEvent.class, new Class[]{keyType, valueType});
        StatefulRedisPubSubConnection subConnection = redisClient.connectPubSub();
        subConnection.addListener((RedisPubSubListener)this);
        subConnection.async().subscribe((Object[])new String[]{this.cacheUpdateChannel});
    }

    public void message(String channel, String message) {
        if (channel.equals(this.cacheUpdateChannel)) {
            this.onCacheUpdateEvent(message);
        } else {
            log.debug("Unsupported cache event received on channel '{}'", (Object)channel);
        }
    }

    private void onCacheUpdateEvent(String message) {
        try {
            CacheUpdateEvent updateEvent = (CacheUpdateEvent)this.objectMapper.readValue(message, this.deserializeType);
            this.eventPublisher.publishEvent((Object)updateEvent);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

