/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis.JedisCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis.JedisCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis.JedisCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import io.github.bucket4j.redis.jedis.cas.JedisBasedProxyManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={JedisBasedProxyManager.JedisBasedProxyManagerBuilder.class})
@ConditionalOnBean(value={JedisPool.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="redis-jedis", matchIfMissing=true)
public class JedisBucket4jConfiguration {
    public final JedisPool jedisPool;
    private final String configCacheName;

    public JedisBucket4jConfiguration(JedisPool jedisPool, Bucket4JBootProperties properties) {
        this.jedisPool = jedisPool;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={SyncCacheResolver.class})
    public SyncCacheResolver bucket4RedisResolver() {
        return new JedisCacheResolver(this.jedisPool);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new JedisCacheManager<String, Bucket4JConfiguration>(this.jedisPool, this.configCacheName, Bucket4JConfiguration.class);
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public JedisCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        return new JedisCacheListener<String, Bucket4JConfiguration>(this.jedisPool, this.configCacheName, String.class, Bucket4JConfiguration.class);
    }
}

