/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.exception.JCacheNotFoundException;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.grid.jcache.JCacheProxyManager;
import javax.cache.Cache;
import javax.cache.CacheManager;

public class JCacheCacheResolver
implements SyncCacheResolver {
    private final CacheManager cacheManager;

    public JCacheCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public ProxyManagerWrapper resolve(String cacheName) {
        Cache springCache = this.cacheManager.getCache(cacheName);
        if (springCache == null) {
            throw new JCacheNotFoundException(cacheName);
        }
        JCacheProxyManager jCacheProxyManager = new JCacheProxyManager(springCache);
        return (key, numTokens, bucketConfiguration, metricsListener, version, replaceStrategy) -> {
            BucketProxy bucket = jCacheProxyManager.builder().withImplicitConfigurationReplacement(version, replaceStrategy).build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
            return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
        };
    }
}

