/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class JCacheCacheListener<K, V>
implements CacheEntryUpdatedListener<K, V>,
Serializable {
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public JCacheCacheListener(Cache<K, V> cache) {
        cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf((Serializable)this), null, true, false));
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
        iterable.forEach(event -> {
            CacheUpdateEvent<Object, Object> updateEvent = new CacheUpdateEvent<Object, Object>(event.getKey(), event.getOldValue(), event.getValue());
            this.eventPublisher.publishEvent(updateEvent);
        });
    }
}

