/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.jcache.JCacheCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.jcache.JCacheCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.jcache.JCacheCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import javax.cache.Caching;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Caching.class, org.springframework.cache.jcache.JCacheCacheManager.class})
@ConditionalOnBean(value={javax.cache.CacheManager.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="jcache", matchIfMissing=true)
public class JCacheBucket4jConfiguration {
    private final javax.cache.CacheManager cacheManager;
    private final String configCacheName;

    public JCacheBucket4jConfiguration(javax.cache.CacheManager cacheManager, Bucket4JBootProperties properties) {
        this.cacheManager = cacheManager;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={SyncCacheResolver.class})
    public SyncCacheResolver bucket4jCacheResolver() {
        return new JCacheCacheResolver(this.cacheManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new JCacheCacheManager<String, Bucket4JConfiguration>(this.cacheManager.getCache(this.configCacheName));
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public JCacheCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        return new JCacheCacheListener<String, Bucket4JConfiguration>(this.cacheManager.getCache(this.configCacheName));
    }
}

