/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.ignite;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ignite.IgniteCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ignite.IgniteCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ignite.IgniteCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import org.apache.ignite.Ignite;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={Ignite.class})
@ConditionalOnBean(value={Ignite.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="ignite", matchIfMissing=true)
public class IgniteBucket4jCacheConfiguration {
    private final Ignite ignite;
    private final String configCacheName;

    public IgniteBucket4jCacheConfiguration(Ignite ignite, Bucket4JBootProperties properties) {
        this.ignite = ignite;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncCacheResolver.class})
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new IgniteCacheResolver(this.ignite);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new IgniteCacheManager<String, Bucket4JConfiguration>(this.ignite.cache(this.configCacheName));
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public IgniteCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        return new IgniteCacheListener<String, Bucket4JConfiguration>(this.ignite.cache(this.configCacheName));
    }
}

