/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={com.hazelcast.spring.cache.HazelcastCacheManager.class})
@ConditionalOnBean(value={com.hazelcast.spring.cache.HazelcastCacheManager.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="hazelcast-spring", matchIfMissing=true)
public class HazelcastSpringBucket4jCacheConfiguration {
    private final HazelcastInstance hazelcastInstance;
    private final String configCacheName;

    public HazelcastSpringBucket4jCacheConfiguration(com.hazelcast.spring.cache.HazelcastCacheManager hazelcastCacheManager, Bucket4JBootProperties properties) {
        this.hazelcastInstance = hazelcastCacheManager.getHazelcastInstance();
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={SyncCacheResolver.class})
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new HazelcastCacheResolver(this.hazelcastInstance, false);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        IMap map = this.hazelcastInstance.getMap(this.configCacheName);
        return new HazelcastCacheManager<String, Bucket4JConfiguration>(map);
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public HazelcastCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        IMap map = this.hazelcastInstance.getMap(this.configCacheName);
        return new HazelcastCacheListener<String, Bucket4JConfiguration>(map);
    }
}

