/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="hazelcast-reactive", matchIfMissing=true)
public class HazelcastReactiveBucket4jCacheConfiguration {
    private final HazelcastInstance hazelcastInstance;
    private final String configCacheName;

    public HazelcastReactiveBucket4jCacheConfiguration(HazelcastInstance hazelcastInstance, Bucket4JBootProperties properties) {
        this.hazelcastInstance = hazelcastInstance;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncCacheResolver.class})
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new HazelcastCacheResolver(this.hazelcastInstance, true);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        IMap map = this.hazelcastInstance.getMap(this.configCacheName);
        return new HazelcastCacheManager<String, Bucket4JConfiguration>(map);
    }

    @Bean
    @ConditionalOnProperty(prefix="bucket4j", name={"filter-config-caching-enabled"}, havingValue="true")
    public HazelcastCacheListener<String, Bucket4JConfiguration> configCacheListener() {
        IMap map = this.hazelcastInstance.getMap(this.configCacheName);
        return new HazelcastCacheListener<String, Bucket4JConfiguration>(map);
    }
}

