/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.grid.hazelcast.HazelcastProxyManager;

public class HazelcastCacheResolver
implements AsyncCacheResolver {
    private final HazelcastInstance hazelcastInstance;
    private final boolean async;

    public HazelcastCacheResolver(HazelcastInstance hazelcastInstance, boolean async) {
        this.hazelcastInstance = hazelcastInstance;
        this.async = async;
    }

    @Override
    public ProxyManagerWrapper resolve(String cacheName) {
        IMap map = this.hazelcastInstance.getMap(cacheName);
        HazelcastProxyManager hazelcastProxyManager = new HazelcastProxyManager(map);
        return (key, numTokens, bucketConfiguration, metricsListener, version, replaceStrategy) -> {
            if (this.async) {
                AsyncBucketProxy bucket = hazelcastProxyManager.asAsync().builder().withImplicitConfigurationReplacement(version, replaceStrategy).build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
                return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
            }
            BucketProxy bucket = hazelcastProxyManager.builder().withImplicitConfigurationReplacement(version, replaceStrategy).build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
            return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
        };
    }
}

