/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.constraintvalidations;

import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicateDefinition;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.constraintvalidations.ValidPredicateNames;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.GenericTypeResolver;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class Bucket4JConfigurationPredicateNameValidator
implements ConstraintValidator<ValidPredicateNames, Bucket4JConfiguration> {
    private final Map<FilterMethod, Map<String, ExecutePredicate<?>>> filterPredicates = new HashMap();

    @Autowired
    public Bucket4JConfigurationPredicateNameValidator(List<ExecutePredicate<?>> executePredicates) {
        ArrayList servletPredicates = new ArrayList();
        ArrayList webfluxPredicates = new ArrayList();
        executePredicates.forEach(x -> {
            Class genericType = GenericTypeResolver.resolveTypeArgument(x.getClass(), ExecutePredicate.class);
            if (genericType == null) {
                return;
            }
            if (genericType.getName().equals("jakarta.servlet.http.HttpServletRequest")) {
                servletPredicates.add(x);
            } else if (genericType == ServerHttpRequest.class) {
                webfluxPredicates.add(x);
            }
        });
        this.filterPredicates.put(FilterMethod.SERVLET, servletPredicates.stream().collect(Collectors.toMap(ExecutePredicate::name, Function.identity())));
        this.filterPredicates.put(FilterMethod.WEBFLUX, webfluxPredicates.stream().collect(Collectors.toMap(ExecutePredicate::name, Function.identity())));
    }

    public boolean isValid(Bucket4JConfiguration configuration, ConstraintValidatorContext context) {
        Set<String> allExecutePredicateNames = configuration.getRateLimits().stream().flatMap(r -> Stream.concat(r.getExecutePredicates().stream(), r.getSkipPredicates().stream())).map(ExecutePredicateDefinition::getName).collect(Collectors.toSet());
        String errorMessage = this.validateExecutePredicates(configuration, allExecutePredicateNames);
        if (errorMessage != null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
        return true;
    }

    private String validateExecutePredicates(Bucket4JConfiguration configuration, Set<String> allExecutePredicateNames) {
        if (configuration.getFilterMethod() == FilterMethod.GATEWAY && !allExecutePredicateNames.isEmpty()) {
            return "Predicates are not supported for Gateway filters";
        }
        List<String> invalidPredicates = allExecutePredicateNames.stream().filter(predicateName -> this.filterPredicates.get((Object)configuration.getFilterMethod()).get(predicateName) == null).toList();
        return invalidPredicates.isEmpty() ? null : this.buildErrorMessage(invalidPredicates);
    }

    private String buildErrorMessage(List<String> invalidPredicates) {
        StringBuilder errorBuilder = new StringBuilder("Invalid predicate name");
        if (invalidPredicates.size() > 1) {
            errorBuilder.append("s");
        }
        errorBuilder.append(": ");
        errorBuilder.append(String.join((CharSequence)", ", invalidPredicates));
        return errorBuilder.toString();
    }
}

