/*
 * Decompiled with CFR 0.152.
 */
package com.geirsson.junit;

import com.geirsson.junit.Ansi;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.runner.Description;
import sbt.testing.Status;

class RunSettings {
    private static final Object NULL = new Object();
    final boolean color;
    final boolean quiet;
    final boolean logAssert;
    final boolean logExceptionClass;
    final Set<String> includeTags;
    final Set<String> excludeTags;
    final boolean useSbtLoggers;
    final boolean verbose;
    final Summary summary;
    final ArrayList<String> globPatterns;
    final Set<String> includeCategories;
    final Set<String> excludeCategories;
    final String testFilter;
    private final boolean decodeScalaNames;
    private final HashMap<String, String> sysprops;
    private final HashSet<String> ignoreRunners = new HashSet();

    RunSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Summary summary, boolean bl6, String string, boolean bl7, HashMap<String, String> hashMap, ArrayList<String> arrayList, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, String string2) {
        this.color = bl;
        this.decodeScalaNames = bl2;
        this.quiet = bl3;
        this.verbose = bl4;
        this.summary = summary;
        this.logAssert = bl6;
        this.logExceptionClass = bl7;
        this.includeTags = set3;
        this.excludeTags = set4;
        for (String string3 : string.split(",")) {
            this.ignoreRunners.add(string3.trim());
        }
        this.sysprops = hashMap;
        this.globPatterns = arrayList;
        this.includeCategories = set;
        this.excludeCategories = set2;
        this.testFilter = string2;
        this.useSbtLoggers = bl5;
    }

    String decodeName(String string) {
        return this.decodeScalaNames ? RunSettings.decodeScalaName(string) : string;
    }

    private static String decodeScalaName(String string) {
        try {
            Class<?> clazz = Class.forName("scala.reflect.NameTransformer");
            Method method = clazz.getMethod("decode", String.class);
            String string2 = (String)method.invoke(null, string);
            return string2 == null ? string : string2;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    String buildInfoName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[33m", "\u001b[33m");
    }

    String buildInfoName(Description description, Status status) {
        switch (status) {
            case Success: {
                return this.buildSuccessName(description);
            }
            case Ignored: 
            case Skipped: {
                return this.buildSkippedName(description);
            }
        }
        return this.buildInfoName(description);
    }

    String buildErrorName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[91m", "\u001b[33m");
    }

    String buildErrorName(Description description, Status status) {
        switch (status) {
            case Failure: {
                return this.buildColoredName(description, "\u001b[91m", "\u001b[91m", "\u001b[91m");
            }
            case Ignored: 
            case Skipped: {
                return this.buildSkippedName(description);
            }
        }
        return this.buildErrorName(description);
    }

    String buildSuccessName(Description description) {
        return this.buildColoredName(description, "\u001b[32m", "\u001b[32m", "\u001b[32m");
    }

    String buildSkippedName(Description description) {
        return this.buildColoredName(description, "\u001b[33m", "\u001b[33m", "\u001b[33m");
    }

    String buildPlainName(Description description) {
        return this.buildColoredName(description, null, null, null);
    }

    String buildTestResult(Status status) {
        switch (status) {
            case Success: {
                return Ansi.c("+ ", "\u001b[32m");
            }
            case Ignored: {
                return Ansi.c("==> i ", "\u001b[33m");
            }
            case Skipped: {
                return Ansi.c("==> s ", "\u001b[33m");
            }
        }
        return Ansi.c("==> X ", "\u001b[91m");
    }

    String buildColoredMessage(Throwable throwable, String string) {
        if (throwable == null) {
            return "null";
        }
        if (!this.logExceptionClass || !this.logAssert && throwable instanceof AssertionError) {
            return throwable.getMessage();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.decodeName(throwable.getClass().getName()));
        stringBuilder.append(": ").append(throwable.getMessage());
        return stringBuilder.toString();
    }

    String buildErrorMessage(Throwable throwable) {
        return this.buildColoredMessage(throwable, "\u001b[91m");
    }

    private String buildColoredName(Description description, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = this.decodeName(description.getClassName());
        stringBuilder.append(Ansi.c(string4, string));
        String string5 = description.getMethodName();
        if (string5 != null) {
            stringBuilder.append('.');
            int n = string5.lastIndexOf(91);
            int n2 = string5.lastIndexOf(93);
            if (n == -1 || n2 < n) {
                stringBuilder.append(Ansi.c(this.decodeName(string5), string2));
            } else {
                stringBuilder.append(Ansi.c(this.decodeName(string5.substring(0, n)), string2));
                stringBuilder.append('[');
                stringBuilder.append(Ansi.c(string5.substring(n + 1, n2), string3));
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    boolean ignoreRunner(String string) {
        return this.ignoreRunners.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> overrideSystemProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Properties properties = System.getProperties();
        synchronized (properties) {
            for (Map.Entry<String, String> entry : this.sysprops.entrySet()) {
                String string = System.getProperty(entry.getKey());
                hashMap.put(entry.getKey(), string == null ? NULL : string);
            }
            for (Map.Entry<String, String> entry : this.sysprops.entrySet()) {
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSystemProperties(Map<String, Object> map) {
        Properties properties = System.getProperties();
        synchronized (properties) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == NULL) {
                    System.clearProperty(entry.getKey());
                    continue;
                }
                System.setProperty(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    static enum Summary {
        SBT,
        ONE_LINE,
        LIST_FAILED;

    }
}

