/*
 * Decompiled with CFR 0.152.
 */
package com.geirsson.junit;

import com.geirsson.junit.RunSettings;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public final class GlobFilter
extends Filter {
    private final ArrayList<Pattern> patterns = new ArrayList();
    private final RunSettings settings;

    public GlobFilter(RunSettings runSettings, Iterable<String> iterable) {
        this.settings = runSettings;
        for (String string : iterable) {
            this.patterns.add(GlobFilter.compileGlobPattern(string));
        }
    }

    public String describe() {
        return "Filters out all tests not matched by the glob patterns";
    }

    public boolean shouldRun(Description description) {
        if (description.isSuite()) {
            return true;
        }
        String string = this.settings.buildPlainName(description);
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    private static Pattern compileGlobPattern(String string) {
        String[] stringArray = string.split("\\*", -1);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(".*");
            }
            if (stringArray[i].isEmpty()) continue;
            stringBuilder.append(Pattern.quote(stringArray[i].replaceAll("\n", "\\n")));
        }
        return Pattern.compile(stringBuilder.toString());
    }
}

