/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.codegen.metadata.ClassMetadata;
import com.sforce.ws.codegen.metadata.FactoryClassMetadata;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.Types;
import java.util.ArrayList;

public class FactoryMetadataConstructor {
    protected final TypeMapper typeMapper;
    protected final String packageName;
    private final Definitions definitions;
    private final String packagePrefix;
    private final boolean addDeprecatedAnnotation;

    public FactoryMetadataConstructor(Definitions definitions, TypeMapper typeMapper, String packagePrefix, boolean addDeprecatedAnnotation) {
        this.definitions = definitions;
        this.typeMapper = typeMapper;
        this.packagePrefix = packagePrefix;
        this.packageName = NameMapper.getPackageName(definitions.getTargetNamespace(), packagePrefix);
        this.addDeprecatedAnnotation = addDeprecatedAnnotation;
    }

    public FactoryClassMetadata getFactoryClassMetadata() {
        ArrayList<ClassMetadata> classes = new ArrayList<ClassMetadata>();
        ClassMetadata sObjectClass = null;
        Types types = this.definitions.getTypes();
        for (Schema schema : types.getSchemas()) {
            String schemaPackageName = NameMapper.getPackageName(schema.getTargetNamespace(), this.packagePrefix);
            for (ComplexType ct : schema.getComplexTypes()) {
                ClassMetadata cm = new ClassMetadata(schemaPackageName, NameMapper.getClassName(ct.getName()), this.getInterfacePackageName(schemaPackageName), this.addDeprecatedAnnotation);
                if (this.typeMapper.isSObject(ct.getSchema().getTargetNamespace(), ct.getName())) {
                    assert (sObjectClass == null);
                    sObjectClass = cm;
                    continue;
                }
                classes.add(cm);
            }
        }
        String className = (this.definitions.getApiType() != null ? this.definitions.getApiType().name() : "Soap") + "ConnectionFactory";
        return new FactoryClassMetadata(this.packageName, className, classes, sObjectClass, this.getInterfacePackageName(), this.addDeprecatedAnnotation);
    }

    protected String getInterfacePackageName(String packageName) {
        return packageName;
    }

    private String getInterfacePackageName() {
        return this.getInterfacePackageName(this.packageName);
    }
}

