/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.codegen.ConnectionMetadataConstructor;
import com.sforce.ws.codegen.metadata.ComplexClassMetadata;
import com.sforce.ws.codegen.metadata.MemberMetadata;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.Types;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class TypeMetadataConstructor {
    private static final String LAX_MINOCCURS = "lax-minoccurs-checking";
    private static final JavaTypeMap javaTypeMap = TypeMetadataConstructor.javaTypeMap();
    protected final ComplexType complexType;
    private final boolean laxMinOccursMode;
    protected final String className;
    private final Types types;
    protected final TypeMapper mapper;
    protected final String packageName;
    protected final boolean addDeprecatedAnnotation;

    private static JavaTypeMap javaTypeMap() {
        JavaTypeMap map = new JavaTypeMap();
        map.put("java.lang.String", new JavaType("readString", "writeString"));
        map.put("int", new JavaType("readInt", "writeInt"));
        map.put("boolean", new JavaType("readBoolean", "writeBoolean"));
        map.put("double", new JavaType("readDouble", "writeDouble"));
        map.put("long", new JavaType("readLong", "writeLong"));
        map.put("float", new JavaType("readFloat", "writeFloat"));
        return map;
    }

    public TypeMetadataConstructor(Types types, Schema schema, ComplexType complexType, File tempDir, TypeMapper typeMapper, boolean addDeprecatedAnnotation) {
        this(types, schema, complexType, tempDir, typeMapper, System.getProperty(LAX_MINOCCURS) != null, addDeprecatedAnnotation);
    }

    public TypeMetadataConstructor(Types types, Schema schema, ComplexType complexType, File tempDir, TypeMapper typeMapper, boolean laxMinOccursMode, boolean addDeprecatedAnnotation) {
        this.packageName = NameMapper.getPackageName(schema.getTargetNamespace(), typeMapper.getPackagePrefix());
        this.types = types;
        this.mapper = typeMapper;
        this.complexType = complexType;
        this.className = NameMapper.getClassName(complexType.getName());
        this.laxMinOccursMode = laxMinOccursMode;
        this.addDeprecatedAnnotation = addDeprecatedAnnotation;
    }

    public String baseClass() {
        StringBuilder sb = new StringBuilder();
        if (this.complexType.getBase() == null) {
            if (this.complexType.isHeader()) {
                sb.append("extends com.sforce.ws.bind.SoapHeaderObject ");
            } else if (this.className.endsWith("Fault")) {
                sb.append("extends com.sforce.ws.SoapFaultException ");
            }
            sb.append("implements com.sforce.ws.bind.XMLizable");
        } else {
            sb.append("extends ").append(this.localJavaType(this.complexType.getBase(), 1, false));
        }
        return sb.toString();
    }

    public String booleanGetMethod(Element element) {
        return "is" + NameMapper.getMethodName(element.getName());
    }

    public String elementDoc(Element element) {
        return element.getName() + " of type " + element.getType();
    }

    public String fieldName(Element element) {
        return NameMapper.getFieldName(element.getName());
    }

    public ComplexClassMetadata generateMetadata() {
        ArrayList<MemberMetadata> memberMetadataList = new ArrayList<MemberMetadata>();
        Iterator<Element> itr = this.getElements();
        while (itr.hasNext()) {
            Element e = itr.next();
            memberMetadataList.add(MemberMetadata.newInstance(this.elementDoc(e), this.javaType(e), this.fieldName(e), this.typeInfo(e), this.initArray(e), this.getMethod(e), this.javaType(e), this.booleanGetMethod(e), this.setMethod(e), this.writeMethod(e), this.loadType(e), this.loadMethod(e), this.isComplexType(e), this.javaTypeInterface(e), this.isArray(e), this.writeMethodName(e)));
        }
        return new ComplexClassMetadata(this.packageName, this.className, this.baseClass(), this.xsiType(), this.superWrite(), this.superLoad(), this.superToString(), memberMetadataList, this.mapper.generateInterfaces(), this.packageName, this.complexType.getBase() == null ? null : this.localJavaType(this.complexType.getBase(), 1, false), this.addDeprecatedAnnotation);
    }

    public Iterator<Element> getElements() {
        Collection sequence = this.complexType.getContent();
        Iterator<Object> it = sequence == null ? Collections.emptyList().iterator() : sequence.getElements();
        return it;
    }

    public String getMethod(Element element) {
        return "get" + NameMapper.getMethodName(element.getName());
    }

    public String initArray(Element element) {
        StringBuilder sb = new StringBuilder();
        if (this.isArray(element.getMaxOccurs())) {
            sb.append(" = new ");
            sb.append(this.mapper.getJavaClassName(element.getType(), this.types, element.isNillable()));
            sb.append("[0]");
        }
        return sb.toString();
    }

    public String javaType(Element element) {
        QName type = element.getType();
        return this.localJavaType(type, element.getMaxOccurs(), element.isNillable());
    }

    protected String javaTypeInterface(Element element) {
        return ConnectionMetadataConstructor.convertJavaClassToInterface(this.javaType(element), this.isComplexType(element));
    }

    public String loadMethod(Element element) {
        String type = this.javaType(element);
        JavaType javaType = javaTypeMap.get(type);
        return javaType.loadMethod;
    }

    protected boolean isComplexType(Element e) {
        return this.types.getComplexTypeAllowNull(e.getType()) != null;
    }

    public String loadType(Element element) {
        if (!this.laxMinOccursMode && element.getMinOccurs() == 1) {
            return "verifyElement";
        }
        return "isElement";
    }

    public String setMethod(Element element) {
        return "set" + NameMapper.getMethodName(element.getName());
    }

    public String writeMethodName(Element element) {
        return "writeField" + NameMapper.getMethodName(element.getName());
    }

    public String superLoad() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "super.loadFields(__in, __typeMapper);";
    }

    public String superToString() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "sb.append(super.toString());";
    }

    public String superWrite() {
        if (!this.complexType.hasBaseClass()) {
            return "";
        }
        return "super.writeFields(__out, __typeMapper);";
    }

    public String typeInfo(Element element) {
        String tns = element.getSchema().getTargetNamespace();
        String name = element.getName();
        String typeNs = element.getType().getNamespaceURI();
        String type = element.getType().getLocalPart();
        int minOcc = element.getMinOccurs();
        int maxOcc = element.getMaxOccurs();
        boolean formQualified = element.getSchema().isElementFormQualified();
        return "\"" + tns + "\",\"" + name + "\",\"" + typeNs + "\",\"" + type + "\"," + minOcc + "," + maxOcc + "," + formQualified;
    }

    public String writeMethod(Element element) {
        String type = this.javaType(element);
        JavaType javaType = javaTypeMap.get(type);
        return javaType.writeMethod;
    }

    public String xsiType() {
        if (this.complexType.getBase() == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("__typeMapper.writeXsiType(__out, \"");
        sb.append(this.complexType.getSchema().getTargetNamespace());
        sb.append("\", \"");
        sb.append(this.complexType.getName());
        sb.append("\");");
        return sb.toString();
    }

    private boolean isArray(int maxOccurs) {
        return maxOccurs == -1 || maxOccurs > 1;
    }

    protected boolean isArray(Element e) {
        return this.isArray(e.getMaxOccurs());
    }

    protected String localJavaType(QName type, int maxOccurs, boolean nillable) {
        String name = this.mapper.getJavaClassName(type, this.types, nillable);
        if (this.isArray(maxOccurs)) {
            name = name + "[]";
        }
        return name;
    }

    private static class JavaTypeMap {
        private HashMap<String, JavaType> map = new HashMap();
        private JavaType defaultType = new JavaType("readObject", "writeObject");

        private JavaTypeMap() {
        }

        public JavaType get(String key) {
            JavaType o = this.map.get(key);
            if (o == null) {
                o = this.defaultType;
            }
            return o;
        }

        public void put(String s, JavaType javaType) {
            this.map.put(s, javaType);
        }
    }

    private static class JavaType {
        String loadMethod;
        String writeMethod;

        public JavaType(String loadMethod, String writeMethod) {
            this.loadMethod = loadMethod;
            this.writeMethod = writeMethod;
        }
    }
}

